/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.lang.constant.ClassDesc;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.constants.ChildInfo;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.ParamInfo;
import org.xvm.asm.constants.PropertyClassTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.javajit.JitFlavor;
import org.xvm.javajit.JitTypeDesc;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class TypeInfo {
    private final Progress f_progress;
    private final TypeConstant f_type;
    private final int f_cInvalidations;
    private final ClassStructure f_struct;
    private final int f_cDepth;
    private final boolean m_fExplicitAbstract;
    private boolean m_fImplicitAbstract;
    private final Map<Object, ParamInfo> f_mapTypeParams;
    private final Annotation[] f_aannoClass;
    private final Annotation[] f_aannoMixin;
    private final TypeConstant f_typeExtends;
    private final TypeConstant f_typeRebases;
    private final TypeConstant f_typeInto;
    private final List<Component.Contribution> f_listProcess;
    private final ListMap<IdentityConstant, TypeConstant.Origin> f_listmapClassChain;
    private final ListMap<IdentityConstant, TypeConstant.Origin> f_listmapDefaultChain;
    private final Map<PropertyConstant, PropertyInfo> f_mapProps;
    private final Map<Object, PropertyInfo> f_mapVirtProps;
    private transient Map<String, PropertyInfo> m_mapPropertiesByName;
    private final Map<MethodConstant, MethodInfo> f_mapMethods;
    private final Map<Object, MethodInfo> f_mapVirtMethods;
    private final ListMap<String, ChildInfo> f_mapChildren;
    private final Set<TypeConstant> f_setDepends;
    private transient Map<SignatureConstant, MethodInfo> m_mapMethodsBySignature;
    private transient JitTypeDesc m_jtd;
    private boolean m_fHasErrors;
    private boolean m_fCacheReady;
    private boolean m_fChildrenChecked;
    private final Map<MethodConstant, MethodInfo> f_cacheById;
    private final Map<Object, MethodInfo> f_cacheByNid;
    private transient TypeInfo m_into;
    private transient TypeInfo m_delegates;
    private transient Set<MethodInfo> m_setAuto;
    private transient Set<MethodInfo> m_setOps;
    private transient TypeConstant m_typeAuto;
    private transient MethodConstant m_methodAuto;
    private volatile transient Map<String, Set<MethodConstant>> m_mapOps;
    private transient Map<String, Set<MethodConstant>> m_mapMethodsByName;
    private transient Map<IdentityConstant, Map<String, PropertyInfo>> m_mapNestedProperties;

    public TypeInfo(TypeConstant type, int cInvalidations, ClassStructure struct, int cDepth, boolean fSynthetic, Map<Object, ParamInfo> mapTypeParams, Annotation[] aannoClass, Annotation[] aannoMixin, TypeConstant typeExtends, TypeConstant typeRebases, TypeConstant typeInto, List<Component.Contribution> listProcess, ListMap<IdentityConstant, TypeConstant.Origin> listmapClassChain, ListMap<IdentityConstant, TypeConstant.Origin> listmapDefaultChain, Map<PropertyConstant, PropertyInfo> mapProps, Map<MethodConstant, MethodInfo> mapMethods, Map<Object, PropertyInfo> mapVirtProps, Map<Object, MethodInfo> mapVirtMethods, ListMap<String, ChildInfo> mapChildren, Set<TypeConstant> setDepends, Progress progress) {
        assert (type != null);
        assert (mapTypeParams != null);
        assert (listmapClassChain != null);
        assert (listmapDefaultChain != null);
        assert (mapProps != null);
        assert (mapMethods != null);
        assert (mapVirtProps != null);
        assert (mapVirtMethods != null);
        assert (setDepends == null || progress == Progress.Incomplete);
        assert (progress != null && progress != Progress.Absent);
        this.f_type = type;
        this.f_cInvalidations = cInvalidations;
        this.f_struct = struct;
        this.f_cDepth = cDepth;
        this.f_mapTypeParams = mapTypeParams;
        this.f_aannoClass = TypeInfo.validateAnnotations(aannoClass);
        this.f_aannoMixin = TypeInfo.validateAnnotations(aannoMixin);
        this.f_typeExtends = typeExtends;
        this.f_typeRebases = typeRebases;
        this.f_typeInto = typeInto;
        this.f_listProcess = listProcess;
        this.f_listmapClassChain = listmapClassChain;
        this.f_listmapDefaultChain = listmapDefaultChain;
        this.f_mapProps = mapProps;
        this.f_mapVirtProps = mapVirtProps;
        this.f_mapMethods = mapMethods;
        this.f_mapVirtMethods = mapVirtMethods;
        this.f_mapChildren = mapChildren;
        this.f_setDepends = setDepends;
        this.f_progress = progress;
        this.f_cacheById = new ConcurrentHashMap<MethodConstant, MethodInfo>(mapMethods);
        this.f_cacheByNid = new ConcurrentHashMap<Object, MethodInfo>(mapVirtMethods);
        boolean bl = this.m_fExplicitAbstract = fSynthetic || !this.isClass() || struct.isExplicitlyAbstract() || TypeInfo.containsAnnotation(aannoClass, "Abstract");
        assert (cInvalidations == 0 || cInvalidations <= type.getConstantPool().getInvalidationCount());
    }

    public TypeInfo(TypeConstant typeFormal, TypeInfo infoConstraint, int cInvalidations) {
        assert (infoConstraint != null);
        assert (infoConstraint.f_progress == Progress.Complete);
        assert (typeFormal != null && typeFormal.isFormalType());
        this.f_type = typeFormal;
        this.f_cInvalidations = cInvalidations;
        this.f_struct = infoConstraint.f_struct;
        this.f_cDepth = infoConstraint.f_cDepth;
        this.f_mapTypeParams = Collections.emptyMap();
        this.f_aannoClass = Annotation.NO_ANNOTATIONS;
        this.f_aannoMixin = Annotation.NO_ANNOTATIONS;
        this.f_typeExtends = infoConstraint.f_type;
        this.f_typeRebases = null;
        this.f_typeInto = null;
        this.f_listProcess = infoConstraint.f_listProcess;
        this.f_listmapClassChain = infoConstraint.f_listmapClassChain;
        this.f_listmapDefaultChain = infoConstraint.f_listmapDefaultChain;
        this.f_mapProps = infoConstraint.f_mapProps;
        this.f_mapVirtProps = infoConstraint.f_mapVirtProps;
        this.f_mapMethods = infoConstraint.f_mapMethods;
        this.f_mapVirtMethods = infoConstraint.f_mapVirtMethods;
        this.f_mapChildren = infoConstraint.f_mapChildren;
        this.f_setDepends = null;
        this.f_progress = Progress.Complete;
        this.f_cacheById = infoConstraint.f_cacheById;
        this.f_cacheByNid = infoConstraint.f_cacheByNid;
        this.m_fExplicitAbstract = true;
        this.m_fImplicitAbstract = false;
        assert (cInvalidations <= typeFormal.getConstantPool().getInvalidationCount());
    }

    public TypeInfo limitAccess(Constants.Access access) {
        assert (this.f_type.getAccess() == Constants.Access.PRIVATE);
        if (access == Constants.Access.PRIVATE) {
            return this;
        }
        assert (access == Constants.Access.PROTECTED || access == Constants.Access.PUBLIC);
        ConstantPool pool = this.pool();
        TypeConstant typeNew = this.f_type.getUnderlyingType();
        if (access == Constants.Access.PROTECTED) {
            typeNew = pool.ensureAccessTypeConstant(typeNew, Constants.Access.PROTECTED);
        }
        HashMap<PropertyConstant, PropertyInfo> mapProps = new HashMap<PropertyConstant, PropertyInfo>();
        HashMap<Object, PropertyInfo> mapVirtProps = new HashMap<Object, PropertyInfo>();
        for (Map.Entry<PropertyConstant, PropertyInfo> entry : this.f_mapProps.entrySet()) {
            PropertyConstant id = entry.getKey();
            PropertyInfo propertyInfo = entry.getValue().limitAccess(access);
            if (propertyInfo == null) continue;
            mapProps.put(id, propertyInfo);
            if (!propertyInfo.isVirtual()) continue;
            mapVirtProps.put(id.resolveNestedIdentity(pool, null), propertyInfo);
        }
        HashMap<MethodConstant, MethodInfo> mapMethods = new HashMap<MethodConstant, MethodInfo>();
        HashMap<Object, MethodInfo> mapVirtMethods = new HashMap<Object, MethodInfo>();
        for (Map.Entry entry : this.f_mapMethods.entrySet()) {
            MethodConstant methodConstant = (MethodConstant)entry.getKey();
            MethodInfo method = (MethodInfo)entry.getValue();
            if (!method.getAccess().isAsAccessibleAs(access)) continue;
            mapMethods.put(methodConstant, method);
            if (!method.isVirtual()) continue;
            mapVirtMethods.put(methodConstant.resolveNestedIdentity(pool, null), method);
        }
        ListMap<String, ChildInfo> mapChildren = new ListMap<String, ChildInfo>(this.f_mapChildren.size());
        for (Map.Entry<String, ChildInfo> entry : this.f_mapChildren.entrySet()) {
            String sName = entry.getKey();
            ChildInfo child = entry.getValue();
            if (child != null && !child.getAccess().isAsAccessibleAs(access)) continue;
            mapChildren.put(sName, child);
        }
        TypeConstant typeConstant = this.limitAccess(this.f_typeExtends, access);
        TypeConstant typeConstant2 = this.limitAccess(this.f_typeRebases, access);
        TypeConstant typeInto = this.limitAccess(this.f_typeInto, access);
        return new TypeInfo(typeNew, this.f_cInvalidations, this.f_struct, this.f_cDepth, false, this.f_mapTypeParams, this.f_aannoClass, this.f_aannoMixin, typeConstant, typeConstant2, typeInto, this.f_listProcess, this.f_listmapClassChain, this.f_listmapDefaultChain, mapProps, mapMethods, mapVirtProps, mapVirtMethods, mapChildren, this.f_setDepends, this.f_progress);
    }

    private TypeConstant limitAccess(TypeConstant type, Constants.Access access) {
        return type == null || type.getAccess() == Constants.Access.PUBLIC ? type : this.pool().ensureAccessTypeConstant(type, access);
    }

    public TypeInfo asInto() {
        TypeInfo info = this.m_into;
        if (info == null) {
            ConstantPool pool = this.pool();
            HashMap<PropertyConstant, PropertyInfo> mapProps = new HashMap<PropertyConstant, PropertyInfo>();
            HashMap<Object, PropertyInfo> mapVirtProps = new HashMap<Object, PropertyInfo>();
            for (Map.Entry<PropertyConstant, PropertyInfo> entry : this.f_mapProps.entrySet()) {
                PropertyConstant id = entry.getKey();
                PropertyInfo prop = entry.getValue();
                prop = prop.asInto();
                mapProps.put(id, prop);
                if (!prop.isVirtual()) continue;
                mapVirtProps.put(id.resolveNestedIdentity(pool, null), prop);
            }
            HashMap<MethodConstant, MethodInfo> mapMethods = new HashMap<MethodConstant, MethodInfo>();
            HashMap<Object, MethodInfo> mapVirtMethods = new HashMap<Object, MethodInfo>();
            for (Map.Entry<MethodConstant, MethodInfo> entry : this.f_mapMethods.entrySet()) {
                MethodConstant id = entry.getKey();
                MethodInfo method = entry.getValue();
                method = method.asInto();
                mapMethods.put(id, method);
                if (!method.isVirtual()) continue;
                mapVirtMethods.put(id.resolveNestedIdentity(pool, null), method);
            }
            info = new TypeInfo(this.f_type, this.f_cInvalidations, this.f_struct, this.f_cDepth, true, this.f_mapTypeParams, this.f_aannoClass, this.f_aannoMixin, this.f_typeExtends, this.f_typeRebases, this.f_typeInto, this.f_listProcess, this.f_listmapClassChain, this.f_listmapDefaultChain, mapProps, mapMethods, mapVirtProps, mapVirtMethods, this.f_mapChildren, this.f_setDepends, this.f_progress);
            if (this.f_progress == Progress.Complete) {
                this.m_into = info;
                info.m_into = info;
            }
        }
        return info;
    }

    public TypeInfo asDelegates() {
        TypeInfo info = this.m_delegates;
        if (info == null) {
            ConstantPool pool = this.pool();
            HashMap<PropertyConstant, PropertyInfo> mapProps = new HashMap<PropertyConstant, PropertyInfo>();
            HashMap<Object, PropertyInfo> mapVirtProps = new HashMap<Object, PropertyInfo>();
            for (Map.Entry<PropertyConstant, PropertyInfo> entry : this.f_mapProps.entrySet()) {
                PropertyConstant id = entry.getKey();
                PropertyInfo prop = entry.getValue();
                if (!prop.isVirtual()) continue;
                mapProps.put(id, prop);
                mapVirtProps.put(id.resolveNestedIdentity(pool, null), prop);
            }
            HashMap<MethodConstant, MethodInfo> mapMethods = new HashMap<MethodConstant, MethodInfo>();
            HashMap<Object, MethodInfo> mapVirtMethods = new HashMap<Object, MethodInfo>();
            for (Map.Entry<MethodConstant, MethodInfo> entry : this.f_mapMethods.entrySet()) {
                MethodConstant id = entry.getKey();
                MethodInfo method = entry.getValue();
                if (!method.isVirtual()) continue;
                mapMethods.put(id, method);
                mapVirtMethods.put(id.resolveNestedIdentity(pool, null), method);
            }
            info = new TypeInfo(this.f_type, this.f_cInvalidations, this.f_struct, this.f_cDepth, true, this.f_mapTypeParams, this.f_aannoClass, this.f_aannoMixin, this.f_typeExtends, this.f_typeRebases, this.f_typeInto, this.f_listProcess, this.f_listmapClassChain, this.f_listmapDefaultChain, mapProps, mapMethods, mapVirtProps, mapVirtMethods, this.f_mapChildren, this.f_setDepends, this.f_progress);
            if (this.f_progress == Progress.Complete) {
                this.m_delegates = info;
                info.m_delegates = info;
            }
        }
        return info;
    }

    public void contributeChains(ListMap<IdentityConstant, TypeConstant.Origin> listmapClassChain, ListMap<IdentityConstant, TypeConstant.Origin> listmapDefaultChain, Component.Composition composition) {
        TypeConstant typeConstant = this.f_type;
        Objects.requireNonNull(typeConstant);
        TypeConstant.Origin originTrue = typeConstant.new TypeConstant.Origin(true);
        TypeConstant typeConstant2 = this.f_type;
        Objects.requireNonNull(typeConstant2);
        TypeConstant.Origin originFalse = typeConstant2.new TypeConstant.Origin(false);
        if (composition != Component.Composition.Implements && composition != Component.Composition.Delegates) {
            boolean fAnnotation = composition == Component.Composition.Annotation;
            for (Map.Entry<IdentityConstant, TypeConstant.Origin> entry : this.f_listmapClassChain.entrySet()) {
                IdentityConstant constId = entry.getKey();
                TypeConstant.Origin originThis = entry.getValue();
                TypeConstant.Origin originResult = originThis.isAnchored() & fAnnotation ? originTrue : originFalse;
                TypeConstant.Origin originThat = listmapClassChain.get(constId);
                if (originThat == null) {
                    listmapClassChain.put(constId, originResult);
                    continue;
                }
                if (originThat.isAnchored()) continue;
                listmapClassChain.remove(constId);
                listmapClassChain.put(constId, originResult);
            }
        }
        for (IdentityConstant constId : this.f_listmapDefaultChain.keySet()) {
            listmapDefaultChain.putIfAbsent(constId, originTrue);
        }
    }

    public Set<TypeConstant> collectDependTypes(Set<TypeConstant> setDepends) {
        if (this.f_setDepends != null) {
            if (setDepends == null) {
                setDepends = new HashSet<TypeConstant>();
            }
            for (TypeConstant type : this.f_setDepends) {
                if (type instanceof UnionTypeConstant) {
                    UnionTypeConstant typeUnion = (UnionTypeConstant)type;
                    typeUnion.decompose(setDepends);
                    continue;
                }
                setDepends.add(type);
            }
        }
        return setDepends;
    }

    public boolean dependsOn(TypeConstant type) {
        return this.f_setDepends != null && this.f_setDepends.contains(type.removeAccess());
    }

    public TypeConstant getType() {
        return this.f_type;
    }

    int getInvalidationCount() {
        return this.f_cInvalidations;
    }

    public boolean needsRebuild(Set<IdentityConstant> setModified) {
        if (setModified == null || setModified.isEmpty()) {
            return false;
        }
        for (Component.Contribution contrib : this.f_listProcess) {
            if (!contrib.getTypeConstant().isComposedOfAny(setModified)) continue;
            return true;
        }
        return false;
    }

    public ClassStructure getClassStructure() {
        return this.f_struct;
    }

    public IdentityConstant getIdentity() {
        IdentityConstant identityConstant;
        TypeConstant typeConstant = this.f_type;
        if (typeConstant instanceof PropertyClassTypeConstant) {
            PropertyClassTypeConstant typeProp = (PropertyClassTypeConstant)typeConstant;
            identityConstant = typeProp.getProperty();
        } else {
            identityConstant = this.f_struct == null ? null : this.f_struct.getIdentityConstant();
        }
        return identityConstant;
    }

    public Component.Format getFormat() {
        return this.f_struct == null ? Component.Format.INTERFACE : this.f_struct.getFormat();
    }

    public boolean isExplicitlyAbstract() {
        return this.m_fExplicitAbstract;
    }

    public boolean isAbstract() {
        this.ensureCaches();
        return this.m_fImplicitAbstract || this.m_fExplicitAbstract;
    }

    public boolean isStatic() {
        return this.f_struct != null && this.f_struct.isStatic();
    }

    public boolean isSingleton() {
        return this.f_struct != null && this.f_struct.isSingleton();
    }

    public boolean isInstantiableSingleton() {
        return this.isSingleton() && this.f_struct.findConstructor(TypeConstant.NO_TYPES) != null;
    }

    public boolean isSynthetic() {
        return this.f_struct != null && this.f_struct.isSynthetic();
    }

    public boolean isClass() {
        return switch (this.getFormat()) {
            case Component.Format.MODULE, Component.Format.PACKAGE, Component.Format.CLASS, Component.Format.CONST, Component.Format.ENUM, Component.Format.ENUMVALUE, Component.Format.SERVICE -> true;
            default -> false;
        };
    }

    public boolean isNewable(boolean fSingleton, ErrorListener errs) {
        if (!this.isClass() || fSingleton ? !this.isInstantiableSingleton() : this.isSingleton()) {
            return false;
        }
        if (this.isVirtualChildClass()) {
            if (this.isExplicitlyAbstract()) {
                return false;
            }
            TypeConstant typeParent = this.f_type.getParentType();
            if (!typeParent.ensureTypeInfo(errs).isNewable(false, ErrorListener.BLACKHOLE)) {
                return true;
            }
        }
        if (this.isAbstract()) {
            return false;
        }
        if (!this.m_fChildrenChecked && !this.f_mapChildren.isEmpty()) {
            ConstantPool pool = this.pool();
            for (ChildInfo infoChild : this.f_mapChildren.values()) {
                TypeInfo info;
                if (!infoChild.isVirtualClass()) continue;
                ClassStructure clz = (ClassStructure)infoChild.getComponent();
                TypeConstant type = pool.ensureVirtualChildTypeConstant(this.f_type, clz.getName());
                if (clz.isParameterized()) {
                    type = pool.ensureParameterizedTypeConstant(type, clz.getFormalType().getParamTypesArray());
                }
                if ((info = type.ensureTypeInfo(errs)).isExplicitlyAbstract() || !info.isAbstract()) continue;
                return false;
            }
            this.m_fChildrenChecked = true;
        }
        TypeConstant typeStruct = this.pool().ensureAccessTypeConstant(this.f_type, Constants.Access.STRUCT);
        typeStruct.ensureTypeInfo(errs);
        return !errs.hasSeriousErrors();
    }

    public void reportNotNewable(String sTarget, String sChild, boolean fSingleton, ErrorListener errs) {
        TypeConstant type = this.getType();
        if (!this.isClass()) {
            type.log(errs, Severity.ERROR, "COMPILER-32", sTarget);
            return;
        }
        if (this.isExplicitlyAbstract()) {
            type.log(errs, Severity.ERROR, "COMPILER-169", sTarget);
            return;
        }
        if (fSingleton) {
            if (!this.isInstantiableSingleton()) {
                type.log(errs, Severity.ERROR, "COMPILER-62", sTarget);
                return;
            }
        } else if (this.isSingleton()) {
            type.log(errs, Severity.ERROR, "COMPILER-170", sTarget);
            return;
        }
        for (PropertyInfo propertyInfo : this.f_mapProps.values()) {
            if (!propertyInfo.isExplicitlyAbstract()) continue;
            if (sChild == null) {
                type.log(errs, Severity.ERROR, "COMPILER-171", sTarget, propertyInfo.getName());
            } else {
                type.log(errs, Severity.ERROR, "COMPILER-173", sTarget, sChild, propertyInfo.getName());
            }
            return;
        }
        for (MethodInfo methodInfo : this.f_mapMethods.values()) {
            if (methodInfo.isConstructor() && methodInfo.isUncoveredVirtualConstructor(this)) {
                type.log(errs, Severity.ERROR, "VERIFY-86", sTarget, methodInfo.getIdentity().getValueString());
                return;
            }
            if (!methodInfo.isAbstract()) continue;
            if (sChild == null) {
                type.log(errs, Severity.ERROR, "COMPILER-172", sTarget, methodInfo.getSignature().getValueString());
            } else {
                type.log(errs, Severity.ERROR, "COMPILER-174", sTarget, sChild, methodInfo.getSignature().getValueString());
            }
            return;
        }
        for (Map.Entry entry : this.getChildInfosByName().entrySet()) {
            TypeInfo info;
            ChildInfo infoChild = (ChildInfo)entry.getValue();
            if (!infoChild.isVirtualClass()) continue;
            String sName = (String)entry.getKey();
            ClassStructure clzChild = (ClassStructure)infoChild.getIdentity().getComponent();
            TypeConstant typeChild = this.pool().ensureVirtualChildTypeConstant(this.getType(), sName);
            if (clzChild.isParameterized()) {
                typeChild = this.pool().ensureParameterizedTypeConstant(typeChild, clzChild.getFormalType().getParamTypesArray());
            }
            if ((info = typeChild.ensureTypeInfo(errs)).isExplicitlyAbstract() || !info.isAbstract()) continue;
            info.reportNotNewable(sTarget, sName, false, errs);
            break;
        }
        assert (errs.isSilent() || errs.hasSeriousErrors());
    }

    public boolean isTopLevel() {
        return this.f_struct == null || this.f_struct.isTopLevel();
    }

    public boolean isVirtualChildClass() {
        return this.f_struct != null && this.f_struct.isVirtualChildClass();
    }

    public boolean isAnonInnerClass() {
        return this.f_struct != null && this.f_struct.isAnonInnerClass();
    }

    public Map<Object, ParamInfo> getTypeParams() {
        return this.f_mapTypeParams;
    }

    public Annotation[] getClassAnnotations() {
        return this.f_aannoClass;
    }

    public Annotation[] getMixinAnnotations() {
        return this.f_aannoMixin;
    }

    public TypeConstant getRebases() {
        return this.f_typeRebases;
    }

    public TypeConstant getExtends() {
        return this.f_typeExtends;
    }

    public TypeConstant getInto() {
        return this.f_typeInto;
    }

    public List<Component.Contribution> getContributionList() {
        return this.f_listProcess;
    }

    public ListMap<IdentityConstant, TypeConstant.Origin> getClassChain() {
        return this.f_listmapClassChain;
    }

    public ListMap<IdentityConstant, TypeConstant.Origin> getDefaultChain() {
        return this.f_listmapDefaultChain;
    }

    public TypeConstant calculateChildType(ConstantPool pool, String sName) {
        ChildInfo childinfo = this.f_mapChildren.get(sName);
        if (childinfo == null) {
            return null;
        }
        Component child = childinfo.getComponent();
        if (child instanceof TypedefStructure) {
            TypeConstant typeTypedef = ((TypedefConstant)child.getIdentityConstant()).getReferredToType();
            return typeTypedef.resolveGenerics(pool, this.f_type);
        }
        ClassStructure clz = (ClassStructure)child;
        return clz.isVirtualChild() ? pool.ensureVirtualChildTypeConstant(this.f_type, sName) : (clz.isInnerChild() ? pool.ensureInnerChildTypeConstant(this.f_type, (ClassConstant)clz.getIdentityConstant()) : (clz.isAnonInnerClass() ? pool.ensureAnonymousClassTypeConstant(this.f_type, (ClassConstant)clz.getIdentityConstant()) : clz.getIdentityConstant().getType()));
    }

    public Map<PropertyConstant, PropertyInfo> getProperties() {
        return this.f_mapProps;
    }

    public Map.Entry<PropertyConstant, PropertyInfo>[] sortedProperties() {
        Map.Entry[] aEntry = this.f_mapProps.entrySet().toArray(new Map.Entry[0]);
        if (aEntry.length > 1) {
            Arrays.sort(aEntry, PropertyInfo.RANKER);
        }
        return aEntry;
    }

    public Map<Object, PropertyInfo> getVirtProperties() {
        return this.f_mapVirtProps;
    }

    public Map<String, PropertyInfo> ensurePropertiesByName() {
        Map<String, PropertyInfo> map = this.m_mapPropertiesByName;
        if (map == null) {
            map = new HashMap<String, PropertyInfo>();
            for (Map.Entry<PropertyConstant, PropertyInfo> entry : this.f_mapProps.entrySet()) {
                PropertyConstant id = entry.getKey();
                PropertyInfo prop = entry.getValue();
                if (!id.isTopLevel()) continue;
                map.compute(prop.getName(), (sName, propPrev) -> propPrev == null ? prop : this.selectVisible(prop, (PropertyInfo)propPrev));
            }
            this.m_mapPropertiesByName = map;
        }
        return map;
    }

    private PropertyInfo selectVisible(PropertyInfo prop1, PropertyInfo prop2) {
        if (prop1.isVirtual()) {
            assert (!prop2.isVirtual());
            return prop1;
        }
        if (prop2.isVirtual()) {
            return prop2;
        }
        if (prop1 == prop2) {
            return prop1;
        }
        IdentityConstant idClass1 = prop1.getIdentity().getClassIdentity();
        IdentityConstant idClass2 = prop2.getIdentity().getClassIdentity();
        assert (idClass1 != null && idClass2 != null && !idClass1.equals(idClass2));
        int of1 = this.indexOfClass(this.f_listmapClassChain, idClass1);
        int of2 = this.indexOfClass(this.f_listmapClassChain, idClass2);
        if (of1 >= 0) {
            return of2 >= 0 && of2 < of1 ? prop2 : prop1;
        }
        if (of2 >= 0) {
            return prop2;
        }
        of1 = this.indexOfClass(this.f_listmapDefaultChain, idClass1);
        of2 = this.indexOfClass(this.f_listmapDefaultChain, idClass2);
        if (of1 >= 0) {
            return of2 >= 0 && of2 < of1 ? prop2 : prop1;
        }
        if (of2 >= 0) {
            return prop2;
        }
        throw new IllegalStateException();
    }

    private int indexOfClass(ListMap<IdentityConstant, TypeConstant.Origin> listmap, IdentityConstant idClass) {
        int i = 0;
        for (IdentityConstant id : listmap.keySet()) {
            if (id.equals(idClass)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized Map<String, PropertyInfo> ensureNestedPropertiesByName(MethodConstant idMethod) {
        Map<String, PropertyInfo> map;
        MethodStructure method = (MethodStructure)idMethod.getComponent();
        if (method != null && !method.hasChildren()) {
            return Collections.emptyMap();
        }
        Map<IdentityConstant, Map<String, PropertyInfo>> mapProps = this.m_mapNestedProperties;
        if (mapProps == null) {
            this.m_mapNestedProperties = mapProps = new HashMap<IdentityConstant, Map<String, PropertyInfo>>();
        }
        if ((map = mapProps.get(idMethod)) == null) {
            for (PropertyInfo prop : this.f_mapProps.values()) {
                if (!prop.getParent().equals(idMethod)) continue;
                if (map == null) {
                    map = new HashMap<String, PropertyInfo>();
                }
                map.put(prop.getName(), prop);
            }
            if (map == null) {
                map = Collections.emptyMap();
            }
            mapProps.put(idMethod, map);
        }
        return map;
    }

    public synchronized Map<String, PropertyInfo> ensureNestedPropertiesByName(PropertyConstant idProp) {
        Map<String, PropertyInfo> map;
        Map<IdentityConstant, Map<String, PropertyInfo>> mapProps = this.m_mapNestedProperties;
        if (mapProps == null) {
            this.m_mapNestedProperties = mapProps = new HashMap<IdentityConstant, Map<String, PropertyInfo>>();
        }
        if ((map = mapProps.get(idProp)) == null) {
            for (Map.Entry<PropertyConstant, PropertyInfo> entry : this.f_mapProps.entrySet()) {
                PropertyConstant idTest = entry.getKey();
                PropertyInfo prop = entry.getValue();
                if (!idTest.getParentConstant().equals(idProp)) continue;
                if (map == null) {
                    map = new HashMap<String, PropertyInfo>();
                }
                map.put(prop.getName(), prop);
            }
            if (map == null) {
                map = Collections.emptyMap();
            }
            mapProps.put(idProp, map);
        }
        return map;
    }

    public IdentityConstant findName(ConstantPool pool, String sName) {
        PropertyInfo prop = this.findProperty(sName);
        if (prop != null) {
            return prop.getIdentity();
        }
        Set<MethodConstant> setMethod = this.findMethods(sName, -1, MethodKind.Any);
        switch (setMethod.size()) {
            case 0: {
                break;
            }
            case 1: {
                return setMethod.iterator().next();
            }
            default: {
                return setMethod.iterator().next().getParentConstant();
            }
        }
        TypeConstant typeChild = this.calculateChildType(pool, sName);
        return typeChild != null && typeChild.isSingleDefiningConstant() ? typeChild.getSingleUnderlyingClass(true) : null;
    }

    public PropertyInfo findProperty(String sName) {
        return this.ensurePropertiesByName().get(sName);
    }

    public PropertyInfo findProperty(PropertyConstant id) {
        return this.findProperty(id, false);
    }

    public PropertyInfo findProperty(PropertyConstant id, boolean fRuntime) {
        PropertyStructure prop;
        PropertyInfo infoProp = this.f_mapProps.get(id);
        if (infoProp != null) {
            return infoProp;
        }
        IdentityConstant idParent = id.getClassIdentity();
        if (!idParent.equals(this.getIdentity()) && (prop = (PropertyStructure)id.getComponent()) != null && prop.getAccess() == Constants.Access.PRIVATE) {
            TypeConstant.Origin origin = this.f_listmapClassChain.get(idParent);
            if (origin == null) {
                return null;
            }
            TypeConstant typeParent = origin.getType();
            TypeInfo infoParent = this.pool().ensureAccessTypeConstant(typeParent, Constants.Access.PRIVATE).ensureTypeInfo();
            return infoParent.findProperty(id);
        }
        if (id.isTopLevel()) {
            infoProp = this.findProperty(id.getName());
            return infoProp != null && (fRuntime || infoProp.isIdentityValid(id)) ? infoProp : null;
        }
        int cDeep = id.getNestedDepth();
        Object nidThis = id.getNestedIdentity();
        for (Map.Entry<PropertyConstant, PropertyInfo> entry : this.f_mapProps.entrySet()) {
            PropertyConstant idThat = entry.getKey();
            if (idThat.getNestedDepth() != cDeep || !nidThis.equals(idThat.getNestedIdentity())) continue;
            infoProp = entry.getValue();
            if (!fRuntime && !infoProp.isIdentityValid(id)) continue;
            return infoProp;
        }
        return null;
    }

    public PropertyInfo findPropertyByNid(Object nid) {
        if (nid instanceof String) {
            String sName = (String)nid;
            return this.findProperty(sName);
        }
        IdentityConstant.NestedIdentity nidThis = (IdentityConstant.NestedIdentity)nid;
        for (Map.Entry<PropertyConstant, PropertyInfo> entry : this.f_mapProps.entrySet()) {
            PropertyConstant idThat = entry.getKey();
            if (!nidThis.equals(idThat.getNestedIdentity())) continue;
            return entry.getValue();
        }
        return null;
    }

    public TypeInfo findPropertyOrigin(PropertyConstant idProp) {
        TypeConstant.Origin origin = this.getClassChain().get(idProp.getClassIdentity());
        if (origin != null) {
            TypeConstant typeOrigin = origin.getType();
            TypeInfo infoOrigin = this.pool().ensureAccessTypeConstant(typeOrigin, Constants.Access.PRIVATE).ensureTypeInfo();
            if (infoOrigin.findProperty(idProp, true) != null) {
                return infoOrigin;
            }
        }
        return null;
    }

    public Map<MethodConstant, MethodInfo> getMethods() {
        return this.f_mapMethods;
    }

    public Map.Entry<MethodConstant, MethodInfo>[] sortedMethods() {
        Map.Entry[] aEntry = this.f_mapMethods.entrySet().toArray(new Map.Entry[0]);
        if (aEntry.length > 1) {
            Arrays.sort(aEntry, MethodInfo.RANKER);
        }
        return aEntry;
    }

    public Map<Object, MethodInfo> getVirtMethods() {
        return this.f_mapVirtMethods;
    }

    public Map<SignatureConstant, MethodInfo> ensureMethodsBySignature() {
        Map<SignatureConstant, MethodInfo> map = this.m_mapMethodsBySignature;
        if (map == null) {
            map = new HashMap<SignatureConstant, MethodInfo>();
            for (Map.Entry<MethodConstant, MethodInfo> entry : this.f_mapMethods.entrySet()) {
                MethodConstant idMethod = entry.getKey();
                if (!idMethod.isTopLevel()) continue;
                map.put(idMethod.getSignature(), entry.getValue());
            }
            this.m_mapMethodsBySignature = map;
        }
        return map;
    }

    public MethodInfo getMethodBySignature(SignatureConstant sig) {
        return this.getMethodBySignature(sig, false);
    }

    public MethodInfo getMethodBySignature(SignatureConstant sig, boolean fRuntime) {
        MethodInfo method = this.f_mapVirtMethods.get(sig);
        if (method != null) {
            return method;
        }
        Map<SignatureConstant, MethodInfo> mapBySig = this.ensureMethodsBySignature();
        method = mapBySig.get(sig);
        if (method != null) {
            return method;
        }
        TypeConstant typeThis = this.f_type;
        if (typeThis.isFormalType()) {
            typeThis = typeThis.resolveConstraints().removeAutoNarrowing();
        }
        MethodInfo methodBest = null;
        MethodInfo methodCapped = null;
        MethodInfo methodRT = null;
        block0: for (Map.Entry<MethodConstant, MethodInfo> entry : this.f_mapMethods.entrySet()) {
            MethodConstant idTest = entry.getKey();
            MethodInfo methodTest = entry.getValue();
            if (!methodTest.getSignature().getName().equals(sig.getName()) || !idTest.isTopLevel()) continue;
            for (MethodBody body : methodTest.getChain()) {
                TypeConstant typeCtx;
                TypeConstant typeConstant = typeCtx = methodTest.isFunction() || methodTest.isConstructor() ? null : typeThis;
                if (methodTest.isConstructor() && !methodTest.containsVirtualConstructor()) continue;
                SignatureConstant sigTest0 = body.getSignature();
                boolean fEquals0 = sigTest0.equals(sig);
                if (fEquals0 || sigTest0.isSubstitutableFor(sig, typeCtx)) {
                    if (methodTest.isCapped()) {
                        methodCapped = methodTest;
                        continue block0;
                    }
                    methodBest = fEquals0 ? methodTest : this.chooseBest(methodBest, methodTest);
                    continue block0;
                }
                SignatureConstant sigTest1 = this.resolveMethodConstant(body.getIdentity(), methodTest).getSignature();
                boolean fEquals1 = sigTest1.equals(sig);
                if (fEquals1 || sigTest1.isSubstitutableFor(sig, typeCtx)) {
                    if (methodTest.isCapped()) {
                        methodCapped = methodTest;
                        continue block0;
                    }
                    methodBest = fEquals1 ? methodTest : this.chooseBest(methodBest, methodTest);
                    continue block0;
                }
                SignatureConstant sigTest2 = body.getIdentity().getSignature();
                boolean fEquals2 = sigTest2.equals(sig);
                if (fEquals2 || sigTest2.isSubstitutableFor(sig, typeCtx)) {
                    if (methodTest.isCapped()) {
                        methodCapped = methodTest;
                        continue block0;
                    }
                    methodBest = fEquals2 ? methodTest : this.chooseBest(methodBest, methodTest);
                    continue block0;
                }
                if (!fRuntime || methodBest != null || methodCapped != null || !sigTest0.isCallableAs(sig) && !sigTest1.isCallableAs(sig) && !sigTest2.isCallableAs(sig)) continue;
                methodRT = methodTest;
                continue block0;
            }
        }
        if (methodBest != null) {
            mapBySig.putIfAbsent(sig, methodBest);
            return methodBest;
        }
        if (methodCapped != null) {
            mapBySig.putIfAbsent(sig, methodCapped);
            return methodCapped;
        }
        if (methodRT != null) {
            mapBySig.putIfAbsent(sig, methodRT);
            return methodRT;
        }
        if (this.getType().isA(this.pool().typeFunction()) && "invoke".equals(sig.getName())) {
            Set<MethodConstant> set = this.findMethods("invoke", 1, MethodKind.Method);
            assert (set.size() == 1);
            method = this.getMethodById(set.iterator().next(), true);
            mapBySig.putIfAbsent(sig, method);
            return method;
        }
        return null;
    }

    private MethodInfo chooseBest(MethodInfo methodBest, MethodInfo methodTest) {
        if (methodBest == null) {
            return methodTest;
        }
        if (methodBest.containsBody(methodTest.getIdentity())) {
            return methodBest;
        }
        if (methodTest.containsBody(methodBest.getIdentity())) {
            return methodTest;
        }
        System.err.println("conflicting " + String.valueOf(methodBest.getSignature()) + " vs. " + String.valueOf(methodTest.getSignature()));
        return methodBest;
    }

    public MethodInfo getMethodById(MethodConstant id) {
        return this.getMethodById(id, false);
    }

    public MethodInfo getMethodById(MethodConstant id, boolean fRuntime) {
        this.ensureCaches();
        MethodInfo infoMethod = this.f_cacheById.get(id);
        if (infoMethod != null) {
            return infoMethod;
        }
        infoMethod = this.getMethodByNestedId(id.resolveNestedIdentity(this.pool(), this.f_type), fRuntime);
        if (infoMethod != null) {
            this.f_cacheById.put(id, infoMethod);
        }
        return infoMethod;
    }

    public MethodInfo getMethodByNestedId(Object nid) {
        return this.getMethodByNestedId(nid, false);
    }

    public MethodInfo getMethodByNestedId(Object nid, boolean fRuntime) {
        this.ensureCaches();
        MethodInfo info = this.f_cacheByNid.get(nid);
        if (info != null) {
            return info;
        }
        if (nid instanceof SignatureConstant) {
            SignatureConstant sig = (SignatureConstant)nid;
            info = this.getMethodBySignature(sig, fRuntime);
            if (info != null) {
                this.f_cacheByNid.put(sig, info);
                return info;
            }
        } else {
            IdentityConstant.NestedIdentity idNested = (IdentityConstant.NestedIdentity)nid;
            IdentityConstant id = idNested.getIdentityConstant();
            for (MethodInfo infoTest : this.f_mapMethods.values()) {
                if (!infoTest.getIdentity().equals(id)) continue;
                if (!fRuntime || idNested.isCacheable()) {
                    this.f_cacheByNid.put(idNested, infoTest);
                }
                return infoTest;
            }
        }
        return null;
    }

    public MethodBody[] getOptimizedMethodChain(MethodConstant id) {
        MethodInfo info = this.getMethodById(id, true);
        return info == null ? null : info.ensureOptimizedMethodChain(this);
    }

    public MethodBody[] getOptimizedMethodChain(Object nid) {
        MethodInfo info = this.getMethodByNestedId(nid, true);
        return info == null ? null : info.ensureOptimizedMethodChain(this);
    }

    public MethodBody[] getOptimizedGetChain(PropertyConstant id) {
        TypeInfo infoOrigin;
        PropertyInfo prop = this.findProperty(id, true);
        if (prop == null && (infoOrigin = this.findPropertyOrigin(id)) != null && infoOrigin != this) {
            return infoOrigin.getOptimizedGetChain(id);
        }
        return prop == null ? null : prop.ensureOptimizedGetChain(this, null);
    }

    public MethodBody[] getOptimizedSetChain(PropertyConstant id) {
        TypeInfo infoOrigin;
        PropertyInfo prop = this.findProperty(id, true);
        if (prop == null && (infoOrigin = this.findPropertyOrigin(id)) != null && infoOrigin != this) {
            return infoOrigin.getOptimizedSetChain(id);
        }
        return prop == null ? null : prop.ensureOptimizedSetChain(this, null);
    }

    public MethodConstant findCallable(String sName, boolean fMethod, boolean fFunction, TypeConstant[] aRedundant, TypeConstant[] aArgs) {
        int cRedundant = aRedundant == null ? 0 : aRedundant.length;
        int cArgs = aArgs == null ? 0 : aArgs.length;
        Map<MethodConstant, MethodInfo> mapAll = this.getMethods();
        Map.Entry<MethodConstant, MethodInfo> entryBest = null;
        HashMap<MethodConstant, MethodInfo> mapMatch = null;
        block0: for (Map.Entry<MethodConstant, MethodInfo> entry : mapAll.entrySet()) {
            int i;
            MethodConstant id = entry.getKey();
            MethodInfo info = entry.getValue();
            if (!id.isTopLevel() || !id.getName().equals(sName) || id.getRawParams().length < cArgs || id.getRawReturns().length < cRedundant || !(info.isConstructor() ? !fMethod && !fFunction : (info.isFunction() ? fFunction : fMethod))) continue;
            SignatureConstant sig = info.getSignature();
            TypeConstant[] aParams = sig.getRawParams();
            TypeConstant[] aReturns = sig.getRawReturns();
            for (i = 0; i < cRedundant; ++i) {
                TypeConstant typeReturn = aReturns[i];
                TypeConstant typeRedundant = aRedundant[i];
                if (!typeReturn.isA(typeRedundant)) continue block0;
            }
            for (i = 0; i < cArgs; ++i) {
                TypeConstant typeParam = aParams[i];
                TypeConstant typeArg = aArgs[i];
                if (typeArg != null && !typeArg.isAssignableTo(typeParam)) continue block0;
            }
            if (entryBest == null && mapMatch == null) {
                entryBest = entry;
                continue;
            }
            if (entry.getValue().isCapped()) continue;
            if (mapMatch == null) {
                if (entryBest.getValue().isCapped()) {
                    entryBest = entry;
                    continue;
                }
                mapMatch = new HashMap<MethodConstant, MethodInfo>();
                mapMatch.put(entryBest.getKey(), entryBest.getValue());
                entryBest = null;
            }
            mapMatch.put(entry.getKey(), entry.getValue());
        }
        if (entryBest != null) {
            return (MethodConstant)entryBest.getKey();
        }
        if (mapMatch == null) {
            return null;
        }
        System.err.println("conflicting matches " + String.valueOf(mapMatch));
        return null;
    }

    public MethodConstant findConstructor(TypeConstant[] aArgs) {
        return this.findCallable("construct", false, false, TypeConstant.NO_TYPES, aArgs);
    }

    public MethodInfo findVirtualConstructor(SignatureConstant sig) {
        Set<MethodConstant> setConstruct = this.findMethods("construct", sig.getParamCount(), MethodKind.Constructor);
        MethodInfo methodBest = null;
        for (MethodConstant idTest : setConstruct) {
            MethodInfo methodTest = this.getMethodById(idTest);
            for (MethodBody body : methodTest.getChain()) {
                if (!body.isVirtualConstructor() || !body.getSignature().isSubstitutableFor(sig, null)) continue;
                methodBest = methodBest == null ? methodTest : this.chooseBest(methodBest, methodTest);
            }
        }
        return methodBest;
    }

    public boolean containsMultiMethod(String sName) {
        for (MethodConstant idMethod : this.f_mapMethods.keySet()) {
            if (!idMethod.getName().equals(sName) || !idMethod.isTopLevel()) continue;
            return true;
        }
        return false;
    }

    public boolean containsNestedMultiMethod(IdentityConstant idContainer, String sName) {
        MethodStructure method;
        if (idContainer instanceof MethodConstant && (method = (MethodStructure)idContainer.getComponent()) != null && method.getChild(sName) == null) {
            return false;
        }
        return !this.findNestedMethods(idContainer, sName, -1).isEmpty();
    }

    public synchronized Set<MethodInfo> getOpMethodInfos() {
        Set<MethodInfo> setOps = this.m_setOps;
        if (setOps == null) {
            for (MethodInfo info : this.ensureMethodsBySignature().values()) {
                if (!info.isOp()) continue;
                if (setOps == null) {
                    setOps = new HashSet(7);
                }
                setOps.add(info);
            }
            setOps = setOps == null ? Collections.emptySet() : setOps;
            this.m_setOps = setOps;
        }
        return setOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MethodConstant> findOpMethods(String sName, String sOp, int cParams) {
        String sKey;
        Set setOps;
        Map<String, Set<MethodConstant>> mapOps = this.m_mapOps;
        if (mapOps == null) {
            TypeInfo typeInfo = this;
            synchronized (typeInfo) {
                mapOps = this.m_mapOps;
                if (mapOps == null) {
                    this.m_mapOps = mapOps = new ConcurrentHashMap<String, Set<MethodConstant>>();
                }
            }
        }
        if ((setOps = mapOps.get(sKey = sName + sOp + cParams)) == null) {
            setOps = mapOps.computeIfAbsent(sKey, key -> {
                HashSet<MethodConstant> set = null;
                for (MethodInfo method : this.getOpMethodInfos()) {
                    if (!method.isOp(sName, sOp, cParams)) continue;
                    if (set == null) {
                        set = new HashSet<MethodConstant>(7);
                    }
                    set.add(this.resolveMethodConstant(method));
                }
                return set == null ? Collections.emptySet() : set;
            });
        }
        return setOps;
    }

    public MethodInfo findOpMethod(String sName, String sOp, int cParams) {
        Set<MethodConstant> setMethods = this.findOpMethods(sName, sOp, cParams);
        switch (setMethods.size()) {
            case 0: {
                throw new IllegalStateException("Missing operation " + sName + " (" + sOp + ") on " + this.getType().getValueString());
            }
            case 1: {
                MethodConstant idMethod = setMethods.iterator().next();
                return this.getMethodById(idMethod);
            }
        }
        throw new IllegalStateException("Ambiguous operation " + sName + " (" + sOp + ") on " + this.getType().getValueString());
    }

    public MethodConstant resolveMethodConstant(MethodInfo method) {
        return this.resolveMethodConstant(method.getIdentity(), method);
    }

    protected MethodConstant resolveMethodConstant(MethodConstant idMethod, MethodInfo method) {
        SignatureConstant sigResolved;
        ConstantPool pool = this.pool();
        SignatureConstant sigMethod = method.getSignature();
        if (sigMethod.containsAutoNarrowing(false)) {
            TypeConstant type = this.f_type;
            IdentityConstant idCtx = type.isExplicitClassIdentity(true) && !type.isVirtualChild() ? (IdentityConstant)type.getDefiningConstant() : null;
            sigResolved = sigMethod.resolveAutoNarrowing(pool, type, idCtx);
            if (method.isConstructor()) {
                sigResolved = sigResolved.removeAutoNarrowing();
            }
        } else {
            sigResolved = sigMethod;
        }
        if (!sigResolved.equals(idMethod.getSignature())) {
            idMethod = pool.ensureMethodConstant(idMethod.getNamespace(), sigResolved);
            this.f_cacheById.putIfAbsent(idMethod, method);
        }
        return idMethod;
    }

    public synchronized Set<MethodConstant> findMethods(String sName, int cParams, MethodKind kind) {
        String sKind;
        boolean fAny;
        String sKey;
        Set<MethodConstant> setMethods;
        Map<String, Set<MethodConstant>> mapMethods = this.m_mapMethodsByName;
        if (mapMethods == null) {
            this.m_mapMethodsByName = mapMethods = new HashMap<String, Set<MethodConstant>>();
        }
        if ((setMethods = mapMethods.get(sKey = (String)((fAny = cParams == -1) ? sName : sName + ";" + cParams) + (sKind = kind == MethodKind.Any ? "" : kind.key))) == null) {
            HashMap<MethodConstant, MethodInfo> mapCandidates = new HashMap<MethodConstant, MethodInfo>();
            for (Map.Entry<MethodConstant, MethodInfo> entry : this.f_mapMethods.entrySet()) {
                MethodConstant idMethod = entry.getKey();
                if (!idMethod.getName().equals(sName) || !idMethod.isTopLevel()) continue;
                mapCandidates.put(idMethod, entry.getValue());
            }
            for (Map.Entry<MethodConstant, MethodInfo> entry : mapCandidates.entrySet()) {
                MethodConstant id = entry.getKey();
                MethodInfo info = entry.getValue();
                MethodStructure method = info.getTopmostMethodStructure(this);
                if (!kind.matches(method) || info.isCapped()) continue;
                int cAllParams = method.getParamCount();
                int cTypeParams = method.getTypeParamCount();
                int cDefaults = method.getDefaultParamCount();
                int cRequired = cAllParams - cTypeParams - cDefaults;
                if (!fAny && (cRequired > cParams || cParams > cAllParams)) continue;
                if (setMethods == null) {
                    setMethods = new HashSet(1);
                    mapMethods.put(sKey, setMethods);
                }
                MethodConstant idMethod = method.isFunction() ? id : this.resolveMethodConstant(id, info);
                setMethods.add(idMethod);
            }
            if (setMethods == null) {
                setMethods = Collections.emptySet();
                mapMethods.put(sKey, setMethods);
            } else if (fAny && setMethods.size() == 1) {
                int cAllParams = setMethods.iterator().next().getSignature().getParamCount();
                mapMethods.putIfAbsent(sName + ";" + cAllParams + sKind, setMethods);
            }
        }
        return setMethods;
    }

    public synchronized Set<MethodConstant> findNestedMethods(IdentityConstant idContainer, String sName, int cParams) {
        String string;
        Object nid;
        Map<String, Set<MethodConstant>> mapMethods = this.m_mapMethodsByName;
        if (mapMethods == null) {
            this.m_mapMethodsByName = mapMethods = new HashMap<String, Set<MethodConstant>>();
        }
        if ((nid = idContainer.getNestedIdentity()) instanceof SignatureConstant) {
            SignatureConstant sig = (SignatureConstant)nid;
            string = sig.getValueString();
        } else {
            string = nid.toString();
        }
        String sPath = string + "#" + sName;
        boolean fAny = cParams == -1;
        String sKey = fAny ? sPath : sPath + ";" + cParams;
        Set<MethodConstant> setMethods = mapMethods.get(sKey);
        if (setMethods == null) {
            if (fAny) {
                cParams = Integer.MAX_VALUE;
            }
            int cReqDepth = idContainer.getNestedDepth() + 2;
            for (Map.Entry<MethodConstant, MethodInfo> entry : this.f_mapMethods.entrySet()) {
                MethodConstant idMethod;
                int cDefaults;
                int cTypeParams;
                int cAllParams;
                int cRequired;
                MethodConstant idTest = entry.getKey();
                if (idTest.getNestedDepth() != cReqDepth || !idTest.getName().equals(sName) || !idTest.getNamespace().getNestedIdentity().equals(idContainer.getNestedIdentity())) continue;
                SignatureConstant sig = idTest.getSignature();
                MethodInfo info = entry.getValue();
                MethodStructure method = info.getTopmostMethodStructure(this);
                if (info.isCapped() || cParams < (cRequired = (cAllParams = sig.getParamCount()) - (cTypeParams = method.getTypeParamCount()) - (cDefaults = method.getDefaultParamCount()))) continue;
                if (setMethods == null) {
                    setMethods = new HashSet(1);
                    mapMethods.put(sKey, setMethods);
                }
                if ((idMethod = this.resolveMethodConstant(info)).getNestedDepth() < cReqDepth) {
                    idMethod = idMethod.ensureNestedIdentity(this.pool(), idContainer);
                }
                setMethods.add(idMethod);
            }
            if (setMethods == null) {
                setMethods = Collections.emptySet();
                mapMethods.put(sKey, setMethods);
            } else if (fAny && setMethods.size() == 1) {
                int cAllParams = setMethods.iterator().next().getSignature().getParamCount();
                mapMethods.putIfAbsent(sPath + ";" + cAllParams, setMethods);
            }
        }
        return setMethods;
    }

    public MethodInfo getNarrowingMethod(MethodInfo methodCapped) {
        assert (methodCapped.isCapped());
        Object nidNarrowing = methodCapped.getHead().getNarrowingNestedIdentity();
        for (int i = 0; i < 32; ++i) {
            methodCapped = this.getMethodByNestedId(nidNarrowing);
            if (methodCapped == null || !methodCapped.isCapped()) {
                return methodCapped;
            }
            nidNarrowing = methodCapped.getHead().getNarrowingNestedIdentity();
        }
        return null;
    }

    public synchronized Set<MethodInfo> getAutoMethodInfos() {
        Set<MethodInfo> setAuto = this.m_setAuto;
        if (setAuto == null) {
            for (MethodInfo info : this.ensureMethodsBySignature().values()) {
                if (!info.isAuto()) continue;
                if (setAuto == null) {
                    setAuto = new HashSet(7);
                }
                setAuto.add(info);
            }
            setAuto = setAuto == null ? Collections.emptySet() : setAuto;
            this.m_setAuto = setAuto;
        }
        return setAuto;
    }

    public synchronized MethodConstant findConversion(TypeConstant typeDesired) {
        MethodConstant methodMatch = null;
        if (typeDesired.equals(this.m_typeAuto)) {
            methodMatch = this.m_methodAuto;
        } else {
            for (MethodInfo info : this.getAutoMethodInfos()) {
                boolean fSup;
                MethodConstant method = info.getIdentity();
                TypeConstant typeResult = method.getRawReturns()[0];
                if (typeResult.equals(typeDesired)) {
                    return method;
                }
                if (!typeResult.isA(typeDesired)) continue;
                if (methodMatch == null) {
                    methodMatch = method;
                    continue;
                }
                TypeConstant typeResultMatch = methodMatch.getRawReturns()[0];
                boolean fSub = typeResult.isA(typeResultMatch);
                if (fSub ^ (fSup = typeResultMatch.isA(typeResult))) {
                    methodMatch = fSub ? method : methodMatch;
                    continue;
                }
                methodMatch = null;
                break;
            }
            this.m_typeAuto = typeDesired;
            this.m_methodAuto = methodMatch;
        }
        return methodMatch;
    }

    public ListMap<String, ChildInfo> getChildInfosByName() {
        return this.f_mapChildren;
    }

    private ConstantPool pool() {
        return this.f_type.getConstantPool();
    }

    public JitTypeDesc getJitDesc() {
        JitTypeDesc jtd = this.m_jtd;
        if (jtd == null) {
            TypeConstant type = this.getType();
            ClassDesc cd = JitTypeDesc.getPrimitiveClass(type);
            if (cd != null) {
                jtd = this.m_jtd = new JitTypeDesc(type, JitFlavor.Primitive, cd);
            } else {
                cd = JitTypeDesc.getMultiSlotPrimitiveClass(type);
                if (cd != null) {
                    jtd = this.m_jtd = new JitTypeDesc(type, JitFlavor.MultiSlotPrimitive, cd);
                } else {
                    cd = JitTypeDesc.getWidenedClass(type);
                    if (cd != null) {
                        jtd = this.m_jtd = new JitTypeDesc(type, JitFlavor.Widened, cd);
                    } else {
                        assert (type.isSingleUnderlyingClass(true));
                        cd = ClassDesc.of(type.getSingleUnderlyingClass(true).getPathString());
                        jtd = this.m_jtd = new JitTypeDesc(type, JitFlavor.Specific, cd);
                    }
                }
            }
        }
        return jtd;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean fRuntime) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("TypeInfo: ").append(this.f_type).append(" (format=").append((Object)this.getFormat());
        if (this.isAbstract()) {
            sb.append(", abstract");
        }
        if (this.isStatic()) {
            sb.append(", static");
        }
        if (this.isSingleton()) {
            sb.append(", singleton");
        }
        sb.append(")");
        if (!this.f_mapTypeParams.isEmpty()) {
            sb.append("\n- Parameters (").append(this.f_mapTypeParams.size()).append(')');
            i = 0;
            for (Map.Entry<Object, ParamInfo> entry : this.f_mapTypeParams.entrySet()) {
                sb.append("\n  [").append(i++).append("] ").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        if (this.f_typeInto != null) {
            sb.append("\n- Into: ").append(this.f_typeInto.getValueString());
        }
        if (this.f_typeRebases != null) {
            sb.append("\n- Rebases: ").append(this.f_typeRebases.getValueString());
        }
        if (this.f_typeExtends != null) {
            sb.append("\n- Extends: ").append(this.f_typeExtends.getValueString());
        }
        if (!this.f_listmapClassChain.isEmpty()) {
            sb.append("\n- Class Chain (").append(this.f_listmapClassChain.size()).append(')');
            i = 0;
            for (Map.Entry<Object, Object> entry : this.f_listmapClassChain.entrySet()) {
                sb.append("\n  [").append(i++).append("] ").append(((IdentityConstant)entry.getKey()).getValueString());
                if (!((TypeConstant.Origin)entry.getValue()).isAnchored()) continue;
                sb.append(" (Anchored)");
            }
        }
        if (!this.f_listmapDefaultChain.isEmpty()) {
            sb.append("\n- Default Chain (").append(this.f_listmapDefaultChain.size()).append(')');
            i = 0;
            for (IdentityConstant identityConstant : this.f_listmapDefaultChain.keySet()) {
                sb.append("\n  [").append(i++).append("] ").append(identityConstant.getValueString());
            }
        }
        ConstantPool pool = this.pool();
        if (!this.f_mapProps.isEmpty()) {
            sb.append("\n- Properties (").append(this.f_mapProps.size()).append(')');
            int i2 = 0;
            for (Map.Entry<PropertyConstant, PropertyInfo> entry : this.f_mapProps.entrySet()) {
                sb.append("\n  [").append(i2++).append("] ");
                if (this.f_mapVirtProps.containsKey(entry.getKey().resolveNestedIdentity(pool, null))) {
                    sb.append("(v) ");
                }
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        if (!this.f_mapMethods.isEmpty()) {
            sb.append("\n- Methods (").append(this.f_mapMethods.size()).append(')');
            int i3 = 0;
            for (Map.Entry<MethodConstant, MethodInfo> entry : this.f_mapMethods.entrySet()) {
                MethodInfo method = entry.getValue();
                if (fRuntime && method.isCapped()) continue;
                sb.append("\n  [").append(i3++).append("] ");
                if (this.f_mapVirtMethods.containsKey(entry.getKey().resolveNestedIdentity(pool, null))) {
                    sb.append("(v) ");
                }
                if (fRuntime) {
                    MethodBody[] chain = method.ensureOptimizedMethodChain(this);
                    method = chain.length == 0 ? new MethodInfo(new MethodBody(method.getHead(), MethodBody.Implementation.Native), 0) : new MethodInfo(chain, 0);
                }
                sb.append(entry.getKey()).append("=").append(method);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCaches() {
        if (this.m_fCacheReady) {
            return;
        }
        Map<MethodConstant, MethodInfo> map = this.f_cacheById;
        synchronized (map) {
            if (this.m_fCacheReady) {
                return;
            }
            boolean fImplicitAbstract = false;
            for (Map.Entry<MethodConstant, MethodInfo> entry : this.f_mapMethods.entrySet()) {
                MethodInfo info = entry.getValue();
                info.populateCache(entry.getKey(), this.f_cacheById, this.f_cacheByNid);
                if (info.isAbstract()) {
                    fImplicitAbstract = true;
                }
                if (!info.isUncoveredVirtualConstructor(this)) continue;
                fImplicitAbstract = true;
            }
            this.m_fImplicitAbstract = fImplicitAbstract || this.f_mapProps.values().stream().anyMatch(PropertyInfo::isExplicitlyAbstract);
            this.m_fCacheReady = true;
        }
    }

    protected Progress getProgress() {
        return this.f_progress;
    }

    protected boolean isPlaceHolder() {
        return this.f_progress == Progress.Building;
    }

    public void markWithError() {
        this.m_fHasErrors = true;
    }

    public boolean hasErrors() {
        return this.m_fHasErrors;
    }

    private static Annotation[] validateAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            return Annotation.NO_ANNOTATIONS;
        }
        for (Annotation annotation : annotations) {
            if (annotation != null) continue;
            throw new IllegalStateException("null annotation");
        }
        return annotations;
    }

    public MethodInfo validateCapped() {
        for (MethodInfo method : this.f_mapMethods.values()) {
            if (!method.isCapped() || this.getNarrowingMethod(method) != null) continue;
            return method;
        }
        return null;
    }

    public static boolean containsAnnotation(Annotation[] annotations, String sName) {
        if (annotations == null || annotations.length == 0) {
            return false;
        }
        IdentityConstant clzFind = annotations[0].getConstantPool().getImplicitlyImportedIdentity(sName);
        for (Annotation annotation : annotations) {
            if (!annotation.getAnnotationClass().equals(clzFind)) continue;
            return true;
        }
        return false;
    }

    public static enum Progress {
        Absent,
        Building,
        Incomplete,
        Complete;


        public Progress worstOf(Progress that) {
            return this.ordinal() > that.ordinal() ? that : this;
        }
    }

    public static enum MethodKind {
        Constructor("c"),
        Method("m"),
        Function("f"),
        Any("a");

        public final String key;

        private MethodKind(String key) {
            this.key = key;
        }

        public boolean matches(MethodStructure method) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> method.isConstructor();
                case 1 -> {
                    if (!method.isFunction() && !method.isConstructor()) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> method.isFunction();
                case 3 -> true;
            };
        }
    }
}

