/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.FormalTypeChildConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.ast.Context;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.Sentry;
import org.xvm.util.TransientThreadLocal;

public class TypeParameterConstant
extends FormalConstant {
    private final int f_iReg;
    private transient TypeConstant m_typeConstraint;
    private final TransientThreadLocal<Boolean> f_tloReEntry = new TransientThreadLocal();

    public TypeParameterConstant(ConstantPool pool, MethodConstant constMethod, String sName, int iReg) {
        super(pool, constMethod, sName);
        if (iReg < 0 || iReg > 255) {
            throw new IllegalArgumentException("register (" + iReg + ") out of range");
        }
        this.f_iReg = iReg;
    }

    public TypeParameterConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
        this.f_iReg = Handy.readMagnitude(in);
    }

    public MethodConstant getMethod() {
        return (MethodConstant)this.getParentConstant();
    }

    public int getRegister() {
        return this.f_iReg;
    }

    @Override
    public TypeConstant getConstraintType() {
        TypeConstant typeConstraint = this.m_typeConstraint;
        if (typeConstraint != null) {
            return typeConstraint;
        }
        MethodConstant constMethod = this.getMethod();
        if (constMethod.isNascent()) {
            return this.getConstantPool().typeObject();
        }
        int nReg = this.getRegister();
        TypeConstant[] atypeParams = constMethod.getRawParams();
        assert (atypeParams.length > nReg);
        typeConstraint = atypeParams[nReg];
        if (typeConstraint.isGenericType()) {
            this.m_typeConstraint = typeConstraint;
            return this.m_typeConstraint;
        }
        assert (typeConstraint.isTypeOfType() && typeConstraint.isParamsSpecified());
        if ((typeConstraint = typeConstraint.getParamType(0)).containsTypeParameter(true)) {
            this.m_typeConstraint = typeConstraint;
            return this.m_typeConstraint;
        }
        if (!typeConstraint.isParamsSpecified() && typeConstraint.isExplicitClassIdentity(true)) {
            ConstantPool pool = this.getConstantPool();
            ClassStructure clz = (ClassStructure)typeConstraint.getSingleUnderlyingClass(true).getComponent();
            if (clz.isParameterized()) {
                Set setFormalNames = clz.getTypeParams().keySet();
                TypeConstant[] atypeFormal = new TypeConstant[setFormalNames.size()];
                int ix = 0;
                for (StringConstant constName : setFormalNames) {
                    FormalTypeChildConstant constant = pool.ensureFormalTypeChildConstant(this, constName.getValue());
                    atypeFormal[ix++] = ((Constant)constant).getType();
                }
                typeConstraint = pool.ensureParameterizedTypeConstant(typeConstraint, atypeFormal);
            }
        }
        this.m_typeConstraint = typeConstraint;
        return this.m_typeConstraint;
    }

    @Override
    public ExprAST toExprAst(Context ctx) {
        return ctx.getParameter(this.getRegister()).getRegisterAST();
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return new TypeParameterConstant(this.getConstantPool(), (MethodConstant)idParent, this.getName(), this.getRegister());
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        return that.getConstantPool().ensureRegisterConstant((MethodConstant)that, this.getRegister(), this.getName());
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().ensureTerminalTypeConstant(this);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.TypeParameter;
    }

    @Override
    public boolean containsUnresolved() {
        return false;
    }

    @Override
    public boolean canResolve() {
        return this.getParentConstant().getParentConstant().canResolve();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
    }

    @Override
    public TypeParameterConstant resolveTypedefs() {
        return this;
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof TypeParameterConstant)) {
            return -1;
        }
        TypeParameterConstant that = (TypeParameterConstant)obj;
        int nDif = this.f_iReg - that.f_iReg;
        if (nDif != 0 || this.f_tloReEntry.get() != null) {
            return nDif;
        }
        try (Sentry<Boolean> ignore = this.f_tloReEntry.push(true);){
            int n = this.getParentConstant().compareTo(that.getParentConstant());
            return n;
        }
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        this.m_typeConstraint = null;
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        Handy.writePackedLong(out, this.f_iReg);
    }

    @Override
    public String getDescription() {
        return "method=" + this.getMethod().getName() + ", register=" + this.f_iReg;
    }

    @Override
    public int computeHashCode() {
        MethodConstant idMethod = this.getMethod();
        return Hash.of(this.getName(), Hash.of(this.f_iReg, Hash.of(idMethod.getName(), Hash.of(idMethod.getNamespace()))));
    }
}

