/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.Register;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;

public class TypeSequenceTypeConstant
extends TypeConstant {
    public TypeSequenceTypeConstant(ConstantPool pool) {
        super(pool);
    }

    @Override
    public boolean isShared(ConstantPool poolOther) {
        return true;
    }

    @Override
    public TypeConstant resolveTypedefs() {
        return this;
    }

    @Override
    public boolean containsAutoNarrowing(boolean fAllowVirtChild) {
        return false;
    }

    @Override
    public boolean isOnlyNullable() {
        return false;
    }

    @Override
    public TypeConstant combine(ConstantPool pool, TypeConstant that) {
        return that.isTuple() ? that : super.combine(pool, that);
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        return ComponentResolver.ResolutionResult.UNKNOWN;
    }

    @Override
    public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        return this;
    }

    @Override
    public TypeConstant resolveConstraints(boolean fPendingOnly) {
        return this;
    }

    @Override
    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant[] atypeParams) {
        return this;
    }

    @Override
    public TypeConstant[] collectGenericParameters() {
        return null;
    }

    @Override
    public TypeConstant resolveTypeParameter(TypeConstant typeActual, String sFormalName) {
        return null;
    }

    @Override
    public boolean isImmutabilitySpecified() {
        return false;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isAccessSpecified() {
        return false;
    }

    @Override
    public Constants.Access getAccess() {
        return Constants.Access.PUBLIC;
    }

    @Override
    public boolean isAccessModifiable() {
        return false;
    }

    @Override
    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        return false;
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public boolean isTypeOfType() {
        return false;
    }

    @Override
    public TypeConstant.Category getCategory() {
        return TypeConstant.Category.FORMAL;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public boolean extendsClass(IdentityConstant constClass) {
        return false;
    }

    @Override
    public boolean containsTypeParameter(boolean fAllowParams) {
        return false;
    }

    @Override
    public boolean containsRecursiveType() {
        return false;
    }

    @Override
    public boolean containsFunctionType() {
        return false;
    }

    @Override
    public boolean isFormalTypeSequence() {
        return true;
    }

    @Override
    public boolean isGenericType() {
        return false;
    }

    @Override
    public boolean isTypeParameter() {
        return false;
    }

    @Override
    public boolean containsGenericType(boolean fAllowParams) {
        return fAllowParams;
    }

    @Override
    public boolean containsFormalType(boolean fAllowParams) {
        return fAllowParams;
    }

    @Override
    public void collectFormalTypes(boolean fAllowParams, Set<TypeConstant> setFormal) {
    }

    @Override
    public boolean containsDynamicType(Register register) {
        return false;
    }

    @Override
    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        return "Element".equals(sName) ? this.getConstantPool().typeType() : null;
    }

    @Override
    protected TypeInfo buildTypeInfo(ErrorListener errs) {
        ConstantPool pool = this.getConstantPool();
        TypeConstant typeArray = pool.ensureArrayType(pool.typeType());
        return typeArray.ensureTypeInfoInternal(errs);
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        if (typeLeft.isTuple()) {
            int c = typeLeft.getParamsCount();
            for (int i = 0; i < c; ++i) {
                if (typeLeft.getParamType(i).isTypeOfType()) continue;
                return TypeConstant.Relation.INCOMPATIBLE;
            }
            return TypeConstant.Relation.IS_A;
        }
        ConstantPool pool = this.getConstantPool();
        return pool.ensureIndexedType(pool.typeType()).isA(typeLeft) ? TypeConstant.Relation.IS_A : TypeConstant.Relation.INCOMPATIBLE;
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        if (typeRight.isTuple()) {
            return TypeConstant.Relation.IS_A;
        }
        ConstantPool pool = this.getConstantPool();
        return typeRight.isA(pool.ensureIndexedType(pool.typeType())) ? TypeConstant.Relation.IS_A : TypeConstant.Relation.INCOMPATIBLE;
    }

    @Override
    protected TypeConstant.Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return TypeConstant.Usage.NO;
    }

    @Override
    protected TypeConstant.Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return TypeConstant.Usage.NO;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.TurtleType;
    }

    @Override
    protected int compareDetails(Constant that) {
        return this.equals(that) ? 0 : -1;
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof TypeSequenceTypeConstant;
    }

    @Override
    public int computeHashCode() {
        return 42;
    }

    @Override
    public String getValueString() {
        return "Tuple<...>";
    }
}

