/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.NamedConstant;
import org.xvm.asm.constants.RecursiveTypeConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.UnresolvedTypeConstant;

public class TypedefConstant
extends NamedConstant {
    private boolean m_fInitialized;

    public TypedefConstant(ConstantPool pool, IdentityConstant constParent, String sName) {
        super(pool, constParent, sName);
        if (constParent.getFormat() != Constant.Format.Module && constParent.getFormat() != Constant.Format.Package && constParent.getFormat() != Constant.Format.Class && constParent.getFormat() != Constant.Format.Method) {
            throw new IllegalArgumentException("parent module, package, class, or method required");
        }
    }

    public TypedefConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public TypeConstant getReferredToType() {
        TypeConstant typeReferred = ((TypedefStructure)this.getComponent()).getType();
        if (!this.m_fInitialized) {
            final ConstantPool pool = this.getConstantPool();
            final TypedefConstant constSelf = this;
            Consumer<Constant> visitor = new Consumer<Constant>(this){

                @Override
                public void accept(Constant constant) {
                    UnresolvedTypeConstant typeU;
                    if (constant instanceof UnresolvedTypeConstant && (typeU = (UnresolvedTypeConstant)constant).isSingleDefiningConstant() && (constant = typeU.getDefiningConstant()) == constSelf) {
                        RecursiveTypeConstant typeRecursive = new RecursiveTypeConstant(pool, constSelf);
                        typeU.resolve(typeRecursive);
                        typeU.markRecursive();
                        return;
                    }
                    if (constant instanceof TypeConstant) {
                        constant.forEachUnderlying(this);
                    }
                }
            };
            typeReferred.forEachUnderlying(visitor);
            this.m_fInitialized = !typeReferred.containsUnresolved();
        }
        return typeReferred.resolveTypedefs();
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return new TypedefConstant(this.getConstantPool(), idParent, this.getName());
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Typedef;
    }

    @Override
    public boolean containsUnresolved() {
        return false;
    }

    @Override
    public TypedefStructure relocateNestedIdentity(ClassStructure clz) {
        TypedefStructure that;
        Component parent = this.getNamespace().relocateNestedIdentity(clz);
        if (parent == null) {
            return null;
        }
        Component child = parent.getChild(this.getName());
        return child instanceof TypedefStructure ? (that = (TypedefStructure)child) : null;
    }

    @Override
    public TypedefConstant ensureNestedIdentity(ConstantPool pool, IdentityConstant that) {
        return pool.ensureTypedefConstant(this.getParentConstant().ensureNestedIdentity(pool, that), this.getName());
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        return that.getConstantPool().ensureTypedefConstant(that, this.getName());
    }

    @Override
    public String getDescription() {
        return "typedef name=" + this.getValueString();
    }
}

