/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class UInt8ArrayConstant
extends ValueConstant {
    private final byte[] m_abVal;

    public UInt8ArrayConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        int cb = Handy.readMagnitude(in);
        byte[] ab = new byte[cb];
        in.readFully(ab);
        this.m_abVal = ab;
    }

    public UInt8ArrayConstant(ConstantPool pool, byte[] abVal) {
        super(pool);
        assert (abVal != null);
        this.m_abVal = abVal;
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().typeBinary();
    }

    public byte[] getValue() {
        return this.m_abVal;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.UInt8Array;
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof UInt8ArrayConstant)) {
            return -1;
        }
        byte[] abThis = this.m_abVal;
        byte[] abThat = ((UInt8ArrayConstant)that).m_abVal;
        int cbThis = abThis.length;
        int cbThat = abThat.length;
        int cb = Math.min(cbThis, cbThat);
        for (int of = 0; of < cb; ++of) {
            if (abThis[of] == abThat[of]) continue;
            return (abThis[of] & 0xFF) - (abThat[of] & 0xFF);
        }
        return cbThis - cbThat;
    }

    @Override
    public String getValueString() {
        return Handy.byteArrayToHexString(this.m_abVal);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        byte[] ab = this.m_abVal;
        Handy.writePackedLong(out, ab.length);
        out.write(ab);
    }

    @Override
    public String getDescription() {
        return "byte-string=" + this.getValueString();
    }

    @Override
    protected int computeHashCode() {
        return Hash.of(this.m_abVal);
    }
}

