/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.ChildInfo;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.IntersectionTypeConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.ParamInfo;
import org.xvm.asm.constants.PropertyBody;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.RelationalTypeConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xOrdered;
import org.xvm.util.ListMap;

public class UnionTypeConstant
extends RelationalTypeConstant {
    public UnionTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public UnionTypeConstant(ConstantPool pool, TypeConstant constType1, TypeConstant constType2) {
        super(pool, constType1, constType2);
    }

    @Override
    protected TypeConstant cloneRelational(ConstantPool pool, TypeConstant type1, TypeConstant type2) {
        return pool.ensureUnionTypeConstant(type1, type2);
    }

    @Override
    protected TypeConstant simplifyInternal(TypeConstant type1, TypeConstant type2) {
        if (type1.isA(type2)) {
            return type2;
        }
        if (type2.isA(type1)) {
            return type1;
        }
        return null;
    }

    public Set<TypeConstant> collectExtended(TypeConstant typeMatch, Set<TypeConstant> setMatching) {
        if (setMatching == null) {
            setMatching = new HashSet<TypeConstant>();
        }
        this.testExtends(this.m_constType1, typeMatch, setMatching);
        this.testExtends(this.m_constType2, typeMatch, setMatching);
        return setMatching;
    }

    private void testExtends(TypeConstant type, TypeConstant typeMatch, Set<TypeConstant> setSuper) {
        TypeConstant typeConstant = type.resolveTypedefs();
        if (typeConstant instanceof UnionTypeConstant) {
            UnionTypeConstant typeUnion = (UnionTypeConstant)typeConstant;
            typeUnion.collectExtended(typeMatch, setSuper);
        } else if (typeMatch.isA(type)) {
            setSuper.add(type);
        }
    }

    public Set<TypeConstant> collectMatching(TypeConstant typeMatch, Set<TypeConstant> setMatching) {
        if (setMatching == null) {
            setMatching = new HashSet<TypeConstant>();
        }
        this.testMatch(this.m_constType1, typeMatch, setMatching);
        this.testMatch(this.m_constType2, typeMatch, setMatching);
        return setMatching;
    }

    private void testMatch(TypeConstant type, TypeConstant typeMatch, Set<TypeConstant> setSub) {
        TypeConstant typeConstant = type.resolveTypedefs();
        if (typeConstant instanceof UnionTypeConstant) {
            UnionTypeConstant typeUnion = (UnionTypeConstant)typeConstant;
            typeUnion.collectMatching(typeMatch, setSub);
        } else if (type.isA(typeMatch)) {
            setSub.add(type);
        }
    }

    public void decompose(Set<TypeConstant> setTypes) {
        UnionTypeConstant typeUnion;
        TypeConstant type1 = this.m_constType1;
        TypeConstant type2 = this.m_constType2;
        if (type1 instanceof UnionTypeConstant) {
            typeUnion = (UnionTypeConstant)type1;
            typeUnion.decompose(setTypes);
        } else {
            setTypes.add(type1);
        }
        if (type2 instanceof UnionTypeConstant) {
            typeUnion = (UnionTypeConstant)type2;
            typeUnion.decompose(setTypes);
        } else {
            setTypes.add(type2);
        }
    }

    @Override
    public boolean isImmutabilitySpecified() {
        return this.m_constType1.isImmutabilitySpecified() && this.m_constType2.isImmutabilitySpecified();
    }

    @Override
    public boolean isImmutable() {
        return this.m_constType1.isImmutable() && this.m_constType2.isImmutable();
    }

    @Override
    public TypeConstant adjustAccess(IdentityConstant idClass) {
        TypeConstant type1 = this.m_constType1;
        TypeConstant type2 = this.m_constType2;
        TypeConstant type1A = type1.adjustAccess(idClass);
        TypeConstant type2A = type2.adjustAccess(idClass);
        return type1.equals(type1A) && type2.equals(type2A) ? this : this.cloneRelational(this.getConstantPool(), type1A, type2A);
    }

    @Override
    public boolean isNullable() {
        return this.m_constType1.isOnlyNullable() ^ this.m_constType2.isOnlyNullable() || this.m_constType1.isNullable() || this.m_constType2.isNullable();
    }

    @Override
    public TypeConstant removeNullable() {
        if (!this.isNullable()) {
            return this;
        }
        if (this.m_constType1.isOnlyNullable()) {
            assert (!this.m_constType2.isOnlyNullable());
            return this.m_constType2.removeNullable();
        }
        if (this.m_constType2.isOnlyNullable()) {
            assert (!this.m_constType1.isOnlyNullable());
            return this.m_constType1.removeNullable();
        }
        return this.m_constType1.removeNullable().union(this.getConstantPool(), this.m_constType2.removeNullable());
    }

    @Override
    public boolean isIncompatibleCombo(TypeConstant that) {
        TypeConstant type1 = this.m_constType1.resolveTypedefs();
        TypeConstant type2 = this.m_constType2.resolveTypedefs();
        return type1.isIncompatibleCombo(that) && type2.isIncompatibleCombo(that);
    }

    @Override
    public TypeConstant combine(ConstantPool pool, TypeConstant that) {
        TypeConstant typeCombo = super.combine(pool, that);
        if (typeCombo instanceof IntersectionTypeConstant) {
            TypeConstant typeThis1 = this.m_constType1.resolveTypedefs();
            TypeConstant typeThis2 = this.m_constType2.resolveTypedefs();
            if (typeThis1.isIncompatibleCombo(that)) {
                return typeThis2.combine(pool, that);
            }
            if (typeThis2.isIncompatibleCombo(that)) {
                return typeThis1.combine(pool, that);
            }
        }
        return typeCombo;
    }

    @Override
    public TypeConstant andNot(ConstantPool pool, TypeConstant that) {
        TypeConstant type2R;
        TypeConstant type1R;
        TypeConstant type1 = this.getUnderlyingType().resolveTypedefs();
        TypeConstant type2 = this.getUnderlyingType2().resolveTypedefs();
        if (type1.equals(that)) {
            return type2;
        }
        if (type2.equals(that)) {
            return type1;
        }
        if (type1.isA(that) && !type2.isA(that)) {
            return type2;
        }
        if (type2.isA(that) && !type1.isA(that)) {
            return type1;
        }
        if (type1.isRelationalType() || type2.isRelationalType()) {
            type1R = type1.andNot(pool, that);
            type2R = type2.andNot(pool, that);
            if (type1R == null) {
                return type2R;
            }
            if (type2R == null) {
                return type1R;
            }
            if (type1R != type1 || type2R != type2) {
                return type1R.union(pool, type2R);
            }
        }
        if (that instanceof UnionTypeConstant) {
            type1R = this.andNot(pool, that.getUnderlyingType());
            type2R = this.andNot(pool, that.getUnderlyingType2());
            if (type1R == null) {
                return type2R;
            }
            if (type2R == null) {
                return type1R;
            }
            if (type1R != this || type2R != that) {
                return type1R.union(pool, type2R);
            }
        } else if (that.isFormalType()) {
            TypeConstant typeConstraint = that.resolveConstraints();
            return this.andNot(pool, typeConstraint);
        }
        return super.andNot(pool, that);
    }

    @Override
    public TypeConstant.Category getCategory() {
        TypeConstant.Category cat1 = this.m_constType1.getCategory();
        TypeConstant.Category cat2 = this.m_constType2.getCategory();
        return switch (cat1) {
            case TypeConstant.Category.CLASS -> {
                switch (cat2) {
                    case CLASS: {
                        yield TypeConstant.Category.CLASS;
                    }
                }
                yield TypeConstant.Category.OTHER;
            }
            case TypeConstant.Category.IFACE -> {
                switch (cat2) {
                    case IFACE: {
                        yield TypeConstant.Category.IFACE;
                    }
                }
                yield TypeConstant.Category.OTHER;
            }
            default -> TypeConstant.Category.OTHER;
        };
    }

    @Override
    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        return this.m_constType1.isSingleUnderlyingClass(fAllowInterface) && this.m_constType2.isSingleUnderlyingClass(fAllowInterface) && this.m_constType1.getSingleUnderlyingClass(fAllowInterface).equals(this.m_constType2.getSingleUnderlyingClass(fAllowInterface));
    }

    @Override
    public IdentityConstant getSingleUnderlyingClass(boolean fAllowInterface) {
        assert (this.isSingleUnderlyingClass(fAllowInterface));
        return this.m_constType1.getSingleUnderlyingClass(fAllowInterface);
    }

    @Override
    public boolean isConst() {
        return this.m_constType1.isConst() && this.m_constType2.isConst();
    }

    @Override
    public boolean containsGenericParam(String sName) {
        return this.m_constType1.containsGenericParam(sName) && this.m_constType2.containsGenericParam(sName);
    }

    @Override
    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        TypeConstant typeActual1 = this.m_constType1.getGenericParamType(sName, listParams);
        TypeConstant typeActual2 = this.m_constType2.getGenericParamType(sName, listParams);
        if (typeActual1 == null || typeActual2 == null) {
            return null;
        }
        return typeActual1.isA(typeActual2) ? typeActual2 : (typeActual2.isA(typeActual1) ? typeActual1 : this.getConstantPool().ensureUnionTypeConstant(typeActual1, typeActual2));
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        ErrorListener errs = collector.getErrorListener();
        Component.SimpleCollector collector1 = new Component.SimpleCollector(errs);
        ComponentResolver.ResolutionResult result1 = this.m_constType1.resolveContributedName(sName, access, idMethod, collector1);
        Component.SimpleCollector collector2 = new Component.SimpleCollector(errs);
        ComponentResolver.ResolutionResult result2 = this.m_constType2.resolveContributedName(sName, access, idMethod, collector2);
        if (result1 == ComponentResolver.ResolutionResult.RESOLVED) {
            Constant const2;
            Constant const1 = collector1.getResolvedConstant();
            if (result2 == ComponentResolver.ResolutionResult.RESOLVED && !const1.equals(const2 = collector2.getResolvedConstant())) {
                return ComponentResolver.ResolutionResult.UNKNOWN;
            }
            collector.resolvedConstant(const1);
            return ComponentResolver.ResolutionResult.RESOLVED;
        }
        if (result2 == ComponentResolver.ResolutionResult.RESOLVED) {
            Constant const2 = collector2.getResolvedConstant();
            collector.resolvedConstant(const2);
            return ComponentResolver.ResolutionResult.RESOLVED;
        }
        return result1.combine(result2);
    }

    @Override
    public boolean isIntoPropertyType() {
        return this.getUnderlyingType().isIntoPropertyType() || this.getUnderlyingType2().isIntoPropertyType();
    }

    @Override
    public TypeConstant getIntoPropertyType() {
        TypeConstant typeInto1 = this.getUnderlyingType().getIntoPropertyType();
        TypeConstant typeInto2 = this.getUnderlyingType2().getIntoPropertyType();
        TypeConstant typeProperty = this.getConstantPool().typeProperty();
        if (typeInto1 != null && typeInto1.equals(typeProperty)) {
            return typeInto1;
        }
        if (typeInto2 != null && typeInto2.equals(typeProperty)) {
            return typeInto2;
        }
        return Objects.equals(typeInto1, typeInto2) ? typeInto1 : null;
    }

    @Override
    public boolean isIntoMetaData(TypeConstant typeTarget, boolean fStrict) {
        return this.getUnderlyingType().isIntoMetaData(typeTarget, fStrict) || this.getUnderlyingType2().isIntoMetaData(typeTarget, fStrict);
    }

    @Override
    public boolean isIntoVariableType() {
        return this.getUnderlyingType().isIntoVariableType() || this.getUnderlyingType2().isIntoVariableType();
    }

    @Override
    public TypeConstant getIntoVariableType() {
        TypeConstant typeInto1 = this.getUnderlyingType().getIntoVariableType();
        TypeConstant typeInto2 = this.getUnderlyingType2().getIntoVariableType();
        if (typeInto1 == null) {
            return typeInto2;
        }
        if (typeInto2 == null) {
            return typeInto1;
        }
        ConstantPool pool = this.getConstantPool();
        TypeConstant typeVar = pool.typeVar();
        if (typeInto1.equals(typeVar) || typeInto2.equals(typeVar)) {
            return typeVar;
        }
        return pool.typeRef();
    }

    @Override
    public TypeConstant resolveTypeParameter(TypeConstant typeActual, String sFormalName) {
        typeActual = typeActual.resolveTypedefs();
        if (this.getFormat() == typeActual.getFormat()) {
            return super.resolveTypeParameter(typeActual, sFormalName);
        }
        TypeConstant typeResult1 = this.getUnderlyingType().resolveTypeParameter(typeActual, sFormalName);
        TypeConstant typeResult2 = this.getUnderlyingType2().resolveTypeParameter(typeActual, sFormalName);
        return typeResult1 == null ? typeResult2 : (typeResult2 == null || typeResult1.equals(typeResult2) ? typeResult1 : null);
    }

    @Override
    public boolean isNestMateOf(IdentityConstant idClass) {
        return this.m_constType1.isNestMateOf(idClass) && this.m_constType2.isNestMateOf(idClass);
    }

    @Override
    protected Map<Object, ParamInfo> mergeTypeParams(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        if (info1 == null || info2 == null) {
            return Collections.emptyMap();
        }
        ConstantPool pool = this.getConstantPool();
        Map<Object, ParamInfo> map1 = info1.getTypeParams();
        Map<Object, ParamInfo> map2 = info2.getTypeParams();
        HashMap<Object, ParamInfo> map = new HashMap<Object, ParamInfo>(map1);
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object nid = entry.getKey();
            ParamInfo param2 = map2.get(nid);
            if (param2 != null) {
                ParamInfo param1 = (ParamInfo)entry.getValue();
                assert (param1.getName().equals(param2.getName()));
                TypeConstant type1 = param1.getActualType();
                TypeConstant type2 = param2.getActualType();
                if (type2.isA(type1)) continue;
                if (type1.isA(type2)) {
                    entry.setValue(param2);
                    continue;
                }
                TypeConstant typeParam = type1.union(pool, type2);
                entry.setValue(new ParamInfo(param1.getName(), pool.typeObject(), typeParam));
            }
            iter.remove();
        }
        return map;
    }

    @Override
    protected Annotation[] mergeAnnotations(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        return null;
    }

    @Override
    protected Map<PropertyConstant, PropertyInfo> mergeProperties(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        if (info1 == null || info2 == null) {
            return Collections.emptyMap();
        }
        HashMap<PropertyConstant, PropertyInfo> map = new HashMap<PropertyConstant, PropertyInfo>();
        block0: for (Map.Entry<String, PropertyInfo> entry : info1.ensurePropertiesByName().entrySet()) {
            PropertyBody bodySynth;
            boolean f2;
            String sName = entry.getKey();
            PropertyInfo prop2 = info2.findProperty(sName);
            if (prop2 == null) continue;
            PropertyInfo prop1 = entry.getValue();
            if (prop1.equals(prop2)) {
                map.put(prop1.getIdentity(), prop1);
                continue;
            }
            PropertyBody[] abody1 = prop1.getPropertyBodies();
            PropertyBody[] abody2 = prop2.getPropertyBodies();
            for (PropertyBody body1 : abody1) {
                PropertyConstant id1 = body1.getIdentity();
                for (PropertyBody body2 : abody2) {
                    if (!body2.getIdentity().equals(id1)) continue;
                    map.put(id1, new PropertyInfo(body1, prop1.getRank()));
                    continue block0;
                }
            }
            TypeConstant type1 = prop1.getType();
            TypeConstant type2 = prop2.getType();
            boolean f1 = info1.getFormat() == Component.Format.INTERFACE;
            boolean bl = f2 = info2.getFormat() == Component.Format.INTERFACE;
            if (f1 || f2) {
                if (f1 && type2.isA(type1)) {
                    map.put(prop1.getIdentity(), prop1);
                    continue;
                }
                if (!f2 || !type1.isA(type2)) continue;
                map.put(prop2.getIdentity(), prop2);
                continue;
            }
            if (!type1.equals(type2) || !prop1.isVirtual() || !prop2.isVirtual() || prop1.isFormalType() != prop2.isFormalType()) continue;
            ModuleStructure module = this.getConstantPool().getFileStructure().getModule();
            ClassStructure clzSynthParent = module.ensureSyntheticInterface(this.getValueString());
            PropertyStructure propSynth = clzSynthParent.ensureSyntheticProperty(sName, type1.getType());
            if (prop1.isFormalType()) {
                propSynth.markAsGenericTypeParameter();
                bodySynth = new PropertyBody(propSynth, new ParamInfo(sName, prop1.getConstraintType(), prop1.getType()));
            } else {
                bodySynth = new PropertyBody(propSynth, MethodBody.Implementation.Implicit, null, type1, false, true, false, PropertyBody.Effect.None, PropertyBody.Effect.None, false, false, null, null);
            }
            map.put(propSynth.getIdentityConstant(), new PropertyInfo(bodySynth, 0));
        }
        return map;
    }

    @Override
    protected Map<MethodConstant, MethodInfo> mergeMethods(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        if (info1 == null || info2 == null) {
            return Collections.emptyMap();
        }
        HashMap<MethodInfo, TypeInfo> mapCapped = new HashMap<MethodInfo, TypeInfo>();
        HashMap<MethodConstant, MethodInfo> mapMerged = new HashMap<MethodConstant, MethodInfo>();
        block0: for (Map.Entry<SignatureConstant, MethodInfo> entry : info1.ensureMethodsBySignature().entrySet()) {
            boolean f2;
            MethodInfo method2;
            SignatureConstant sig = entry.getKey();
            MethodInfo method1 = entry.getValue();
            if (method1.isConstructor() || (method2 = info2.getMethodBySignature(sig)) == null || method2.isConstructor()) continue;
            if (method1.equals(method2)) {
                mapMerged.put(method1.getIdentity(), method1);
                if (!method1.isCapped()) continue;
                mapCapped.put(method1, info1);
                continue;
            }
            MethodBody[] abody1 = method1.getChain();
            MethodBody[] abody2 = method2.getChain();
            int c1 = abody1.length;
            for (int i1 = 0; i1 < c1; ++i1) {
                MethodBody body1 = abody1[i1];
                MethodConstant id1 = body1.getIdentity();
                for (MethodBody body2 : abody2) {
                    if (!body2.getIdentity().equals(id1)) continue;
                    MethodInfo methodBase = new MethodInfo(Arrays.copyOfRange(abody1, i1, c1), method1.getRank());
                    mapMerged.put(id1, methodBase);
                    if (!methodBase.isCapped()) continue block0;
                    mapCapped.put(methodBase, info1);
                    continue block0;
                }
            }
            boolean f1 = info1.getFormat() == Component.Format.INTERFACE;
            boolean bl = f2 = info2.getFormat() == Component.Format.INTERFACE;
            if (f1 || f2) {
                if (f1) {
                    mapMerged.put(method1.getIdentity(), method1);
                    if (!method1.isCapped()) continue;
                    mapCapped.put(method1, info1);
                    continue;
                }
                mapMerged.put(method2.getIdentity(), method2);
                if (!method2.isCapped()) continue;
                mapCapped.put(method2, info2);
                continue;
            }
            if (!method1.getSignature().equals(method2.getSignature()) || !method1.isVirtual() || !method2.isVirtual() || sig.containsGenericTypes()) continue;
            ModuleStructure module = this.getConstantPool().getFileStructure().getModule();
            ClassStructure clzSynthParent = module.ensureSyntheticInterface(this.getValueString());
            MethodStructure methodSynth = clzSynthParent.ensureSyntheticMethod(sig);
            MethodConstant idSynthMethod = methodSynth.getIdentityConstant();
            mapMerged.put(idSynthMethod, new MethodInfo(new MethodBody(idSynthMethod, sig, MethodBody.Implementation.Implicit), method1.getRank()));
        }
        if (!mapCapped.isEmpty()) {
            for (Map.Entry<SignatureConstant, MethodInfo> entry : mapCapped.entrySet()) {
                MethodInfo methodCapped = (MethodInfo)((Object)entry.getKey());
                TypeInfo info = (TypeInfo)((Object)entry.getValue());
                MethodConstant idCapped = methodCapped.getIdentity();
                MethodInfo methodNarrowing = info.getNarrowingMethod(methodCapped);
                MethodConstant idNarrowing = methodNarrowing.getIdentity();
                if (mapMerged.containsKey(idNarrowing)) continue;
                mapMerged.remove(idCapped);
            }
        }
        return mapMerged;
    }

    @Override
    protected ListMap<String, ChildInfo> mergeChildren(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        if (info1 == null || info2 == null) {
            return ListMap.EMPTY;
        }
        ListMap<String, ChildInfo> map1 = info1.getChildInfosByName();
        ListMap<String, ChildInfo> map2 = info2.getChildInfosByName();
        ListMap<String, ChildInfo> mapMerge = new ListMap<String, ChildInfo>();
        for (Map.Entry<String, ChildInfo> entry : map1.entrySet()) {
            ChildInfo child2;
            ChildInfo child1;
            ChildInfo childM;
            String sChild = entry.getKey();
            if (!map2.containsKey(sChild) || (childM = (child1 = map1.get(sChild)).layerOn(child2 = map2.get(sChild))) == null) continue;
            mapMerge.put(sChild, entry.getValue());
        }
        return mapMerge;
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        TypeConstant thisRight1 = this.getUnderlyingType();
        TypeConstant thisRight2 = this.getUnderlyingType2();
        TypeConstant.Relation rel1 = thisRight1.calculateRelation(typeLeft);
        TypeConstant.Relation rel2 = thisRight2.calculateRelation(typeLeft);
        return rel1.worseOf(rel2);
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        TypeConstant.Relation rel2;
        assert (!(typeRight instanceof UnionTypeConstant));
        TypeConstant thisLeft1 = this.getUnderlyingType();
        TypeConstant thisLeft2 = this.getUnderlyingType2();
        TypeConstant.Relation rel1 = typeRight.calculateRelation(thisLeft1);
        TypeConstant.Relation rel = rel1.bestOf(rel2 = typeRight.calculateRelation(thisLeft2));
        if (rel == TypeConstant.Relation.INCOMPATIBLE) {
            return typeRight.findUnionContribution(this);
        }
        return rel;
    }

    @Override
    protected TypeConstant.Relation findUnionContribution(UnionTypeConstant typeLeft) {
        TypeConstant thisRight1 = this.getUnderlyingType();
        TypeConstant thisRight2 = this.getUnderlyingType2();
        TypeConstant.Relation rel1 = thisRight1.findUnionContribution(typeLeft);
        TypeConstant.Relation rel2 = thisRight2.findUnionContribution(typeLeft);
        return rel1.worseOf(rel2);
    }

    @Override
    protected Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessLeft, List<TypeConstant> listLeft) {
        assert (this.isInterfaceType());
        TypeConstant thisLeft1 = this.getUnderlyingType();
        TypeConstant thisLeft2 = this.getUnderlyingType2();
        Set<SignatureConstant> setMiss1 = thisLeft1.isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
        if (setMiss1.isEmpty()) {
            return setMiss1;
        }
        Set<SignatureConstant> setMiss2 = thisLeft2.isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
        if (setMiss2.isEmpty()) {
            return setMiss2;
        }
        if (setMiss2 != null) {
            setMiss1.addAll(setMiss2);
        }
        return setMiss1;
    }

    @Override
    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        return this.getUnderlyingType().containsSubstitutableMethod(signature, access, fFunction, listParams) && this.getUnderlyingType2().containsSubstitutableMethod(signature, access, fFunction, listParams);
    }

    public TypeConstant extractTuple() {
        TypeConstant typeTuple1 = UnionTypeConstant.extractTuple(this.getUnderlyingType());
        TypeConstant typeTuple2 = UnionTypeConstant.extractTuple(this.getUnderlyingType2());
        return typeTuple1 == null ? typeTuple2 : (typeTuple2 == null ? typeTuple1 : null);
    }

    private static TypeConstant extractTuple(TypeConstant type) {
        TypeConstant typeConstant;
        if (type.isTuple()) {
            typeConstant = type;
        } else {
            TypeConstant typeConstant2 = type.resolveTypedefs();
            if (typeConstant2 instanceof UnionTypeConstant) {
                UnionTypeConstant typeUnion = (UnionTypeConstant)typeConstant2;
                typeConstant = typeUnion.extractTuple();
            } else {
                typeConstant = null;
            }
        }
        return typeConstant;
    }

    @Override
    public int callEquals(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        TypeConstant typeV1 = hValue1.getType();
        TypeConstant typeV2 = hValue2.getType();
        TypeConstant type1 = this.m_constType1;
        if (typeV1.isA(type1) && typeV2.isA(type1)) {
            return type1.callEquals(frame, hValue1, hValue2, iReturn);
        }
        TypeConstant type2 = this.m_constType2;
        if (typeV1.isA(type2) && typeV2.isA(type2)) {
            return type2.callEquals(frame, hValue1, hValue2, iReturn);
        }
        assert (!typeV1.equals(typeV2));
        return frame.assignValue(iReturn, xBoolean.FALSE);
    }

    @Override
    public int callCompare(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        TypeConstant typeV1 = hValue1.getType();
        TypeConstant typeV2 = hValue2.getType();
        TypeConstant type1 = this.m_constType1;
        if (typeV1.isA(type1) && typeV2.isA(type1)) {
            return type1.callCompare(frame, hValue1, hValue2, iReturn);
        }
        TypeConstant type2 = this.m_constType2;
        if (typeV1.isA(type2) && typeV2.isA(type2)) {
            return type2.callCompare(frame, hValue1, hValue2, iReturn);
        }
        assert (!typeV1.equals(typeV2));
        return frame.assignValue(iReturn, xOrdered.makeHandle(typeV1.compareTo(typeV2)));
    }

    @Override
    public int callHashCode(Frame frame, ObjectHandle hValue, int iReturn) {
        TypeConstant type1;
        TypeConstant typeV = hValue.getType();
        if (typeV.isA(type1 = this.m_constType1)) {
            return type1.callHashCode(frame, hValue, iReturn);
        }
        TypeConstant type2 = this.m_constType2;
        if (typeV.isA(type2)) {
            return type2.callHashCode(frame, hValue, iReturn);
        }
        return frame.raiseException("Invalid value type " + typeV.getValueString());
    }

    @Override
    public MethodInfo findFunctionInfo(SignatureConstant sig) {
        MethodInfo info1 = this.m_constType1.findFunctionInfo(sig);
        MethodInfo info2 = this.m_constType2.findFunctionInfo(sig);
        return info1 == null || info2 == null || !info1.getIdentity().equals(info2.getIdentity()) ? null : info1;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.UnionType;
    }

    @Override
    public String getValueString() {
        return this.m_constType1.isOnlyNullable() ? this.m_constType2.getValueString() + "?" : this.m_constType1.getValueString() + " | " + this.m_constType2.getValueString();
    }
}

