/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.ResolvableConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Hash;

public class UnresolvedNameConstant
extends PseudoConstant
implements ResolvableConstant {
    private final String[] m_asName;
    private Constant m_constId;
    private final boolean m_fNoNarrow;
    private Consumer<Constant> m_consumer;
    private transient int m_nUnresolvedHash;

    public UnresolvedNameConstant(ConstantPool pool, String[] names, boolean fExplicitlyNonNarrowing) {
        super(pool);
        this.m_asName = names;
        this.m_fNoNarrow = fExplicitlyNonNarrowing;
    }

    public UnresolvedNameConstant(ConstantPool pool, String sName) {
        this(pool, new String[]{sName}, false);
    }

    @Override
    public Constant resolve() {
        return this.unwrap();
    }

    public String getName() {
        Constant constant = this.m_constId;
        if (constant instanceof IdentityConstant) {
            IdentityConstant constId = (IdentityConstant)constant;
            return constId.getName();
        }
        String[] names = this.m_asName;
        StringBuilder sb = new StringBuilder();
        int c = names.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(names[i]);
        }
        return sb.toString();
    }

    public boolean isNameResolved() {
        return this.m_constId != null;
    }

    public void addConsumer(Consumer<Constant> consumer) {
        Consumer<Constant> consumerCurr = this.m_consumer;
        this.m_consumer = consumerCurr == null ? consumer : constant -> {
            consumerCurr.accept((Constant)constant);
            consumer.accept((Constant)constant);
        };
    }

    @Override
    public Constant getResolvedConstant() {
        return this.m_constId;
    }

    @Override
    public void resolve(Constant constant) {
        assert (this.m_constId == null || this.m_constId == constant || this.m_constId.equals(constant));
        assert (!(constant instanceof TypeConstant));
        this.m_constId = constant;
        if (this.m_consumer != null) {
            this.m_consumer.accept(constant);
        }
    }

    @Override
    public Constant.Format getFormat() {
        return this.isNameResolved() ? this.m_constId.getFormat() : Constant.Format.UnresolvedName;
    }

    @Override
    public boolean isValueCacheable() {
        return this.isNameResolved() && this.m_constId.isValueCacheable();
    }

    @Override
    public boolean isClass() {
        return this.isNameResolved() && this.m_constId.isClass();
    }

    @Override
    public boolean isAutoNarrowing() {
        return this.isNameResolved() && this.m_constId.isAutoNarrowing();
    }

    @Override
    public boolean isProperty() {
        return this.isNameResolved() && this.m_constId.isProperty();
    }

    @Override
    public boolean containsUnresolved() {
        return true;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        if (this.isNameResolved()) {
            visitor.accept(this.m_constId);
        }
    }

    @Override
    public Constant resolveTypedefs() {
        return this.m_constId == null ? this : this.m_constId.resolveTypedefs();
    }

    @Override
    protected void setPosition(int iPos) {
        throw new UnsupportedOperationException("unresolved: " + String.valueOf(this));
    }

    @Override
    protected Object getLocator() {
        if (this.isNameResolved()) {
            Constant constant = this.unwrap();
            if (constant instanceof IdentityConstant) {
                IdentityConstant constId = (IdentityConstant)constant;
                return constId.getLocator();
            }
            if (constant instanceof PseudoConstant) {
                PseudoConstant constPseudo = (PseudoConstant)constant;
                return constPseudo.getLocator();
            }
        }
        return null;
    }

    @Override
    public String getValueString() {
        return this.isNameResolved() ? this.m_constId.getValueString() : this.getName() + (this.m_fNoNarrow ? "!" : "");
    }

    @Override
    protected int compareDetails(Constant that) {
        that = that.resolve();
        if (this.isNameResolved()) {
            return this.unwrap().compareTo(that);
        }
        if (that instanceof UnresolvedNameConstant) {
            UnresolvedNameConstant thatUnresolved = (UnresolvedNameConstant)that;
            String[] asThis = this.m_asName;
            String[] asThat = thatUnresolved.m_asName;
            int cThis = asThis.length;
            int cThat = asThat.length;
            int c = Math.min(cThis, cThat);
            for (int i = 0; i < c; ++i) {
                int n = asThis[i].compareTo(asThat[i]);
                if (n == 0) continue;
                return n;
            }
            int n = cThis - cThat;
            if (n == 0) {
                n = (this.m_fNoNarrow ? 1 : 0) - (thatUnresolved.m_fNoNarrow ? 1 : 0);
            }
            return n;
        }
        return this == that ? 0 : -1;
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        if (this.isNameResolved()) {
            this.m_constId = pool.register(this.m_constId);
        }
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        Constant constant = this.unwrap();
        if (constant instanceof IdentityConstant) {
            IdentityConstant constId = (IdentityConstant)constant;
            constId.assemble(out);
        } else if (constant instanceof PseudoConstant) {
            PseudoConstant costPseudo = (PseudoConstant)constant;
            costPseudo.assemble(out);
        } else {
            throw new IllegalStateException("unresolved: " + this.getName());
        }
    }

    @Override
    public String getDescription() {
        return this.isNameResolved() ? "(resolved) " + this.m_constId.getDescription() : "name=" + this.getName();
    }

    @Override
    public int hashCode() {
        if (this.isNameResolved()) {
            return Hash.of(this.m_constId);
        }
        int nHash = this.m_nUnresolvedHash;
        if (nHash == 0) {
            nHash = Hash.of(this.m_asName, Hash.of(this.m_fNoNarrow));
            if (nHash == 0) {
                nHash = 1000000007;
            }
            this.m_nUnresolvedHash = nHash;
        }
        return nHash;
    }

    @Override
    public int computeHashCode() {
        return 0;
    }
}

