/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataOutput;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ResolvableConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.UnresolvedNameConstant;
import org.xvm.util.Hash;
import org.xvm.util.Severity;

public class UnresolvedTypeConstant
extends TypeConstant
implements ResolvableConstant {
    private final UnresolvedNameConstant m_constId;
    private TypeConstant m_type;
    private boolean m_fRecursive;
    private transient int m_nUnresolvedHash;

    public UnresolvedTypeConstant(ConstantPool pool, UnresolvedNameConstant constUnresolved) {
        super(pool);
        this.m_constId = constUnresolved;
    }

    @Override
    public Constant resolve() {
        return this.unwrap();
    }

    public boolean isTypeResolved() {
        return this.m_type != null;
    }

    public void markRecursive() {
        this.m_fRecursive = true;
    }

    protected TypeConstant getResolvedType() {
        TypeConstant typeResolved;
        TypeConstant type = this.m_type;
        if (type != null && (typeResolved = type.resolveTypedefs()) != type) {
            this.m_type = type = typeResolved;
        }
        return type;
    }

    @Override
    public Constant getResolvedConstant() {
        return this.getResolvedType();
    }

    @Override
    public void resolve(Constant constant) {
        if (!this.m_fRecursive) {
            assert (this.m_type == null || this.m_type == constant);
            this.m_type = (TypeConstant)constant;
        }
    }

    @Override
    public int getTypeDepth() {
        return this.isTypeResolved() ? this.getResolvedType().getTypeDepth() : 1;
    }

    @Override
    public boolean isModifyingType() {
        return this.isTypeResolved() && this.getResolvedType().isModifyingType();
    }

    @Override
    public boolean isRelationalType() {
        return this.isTypeResolved() && this.getResolvedType().isRelationalType();
    }

    @Override
    public TypeConstant getUnderlyingType() {
        if (this.isTypeResolved()) {
            return this.m_type;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isShared(ConstantPool poolOther) {
        return this.isTypeResolved() ? this.getResolvedType().isShared(poolOther) : poolOther == this.getConstantPool();
    }

    @Override
    public boolean isComposedOfAny(Set<IdentityConstant> setIds) {
        if (this.isTypeResolved()) {
            return this.getResolvedType().isComposedOfAny(setIds);
        }
        String sName = this.m_constId.getName();
        for (IdentityConstant id : setIds) {
            if (!id.getName().equals(sName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isImmutable() {
        return this.isTypeResolved() && this.getResolvedType().isImmutable();
    }

    @Override
    public boolean isVirtualChild() {
        return this.isTypeResolved() && this.getResolvedType().isVirtualChild();
    }

    @Override
    public boolean isSingleDefiningConstant() {
        return !this.isTypeResolved() || this.getResolvedType().isSingleDefiningConstant();
    }

    @Override
    public boolean isTuple() {
        if (this.isTypeResolved()) {
            return this.getResolvedType().isTuple();
        }
        String sName = this.m_constId.isNameResolved() ? this.m_constId.getResolvedConstant().getValueString() : this.m_constId.getValueString();
        return "Tuple".equals(sName);
    }

    @Override
    public Constant getDefiningConstant() {
        return this.isTypeResolved() ? this.getResolvedType().getDefiningConstant() : (this.m_constId.isNameResolved() ? this.m_constId.getResolvedConstant() : this.m_constId);
    }

    @Override
    public boolean isConst() {
        return this.isTypeResolved() && this.getResolvedType().isConst();
    }

    @Override
    public boolean isTypeOfType() {
        return this.isTypeResolved() && this.getResolvedType().isTypeOfType();
    }

    @Override
    public boolean isImmutabilitySpecified() {
        return this.isTypeResolved() && this.getResolvedType().isImmutabilitySpecified();
    }

    @Override
    public boolean isAccessSpecified() {
        return this.isTypeResolved() && this.getResolvedType().isAccessSpecified();
    }

    @Override
    public Constants.Access getAccess() {
        return this.isTypeResolved() ? this.getResolvedType().getAccess() : Constants.Access.PUBLIC;
    }

    @Override
    public boolean isAccessModifiable() {
        return this.isTypeResolved() && this.getResolvedType().isAccessModifiable();
    }

    @Override
    public boolean isNullable() {
        return this.isTypeResolved() && this.getResolvedType().isNullable();
    }

    @Override
    public boolean isOnlyNullable() {
        return this.isTypeResolved() && this.getResolvedType().isOnlyNullable();
    }

    @Override
    public TypeConstant removeNullable() {
        if (this.isTypeResolved()) {
            return this.getResolvedType().removeNullable();
        }
        throw new IllegalStateException();
    }

    @Override
    public TypeConstant.Category getCategory() {
        return this.isTypeResolved() ? this.getResolvedType().getCategory() : TypeConstant.Category.OTHER;
    }

    @Override
    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        return this.isTypeResolved() && this.getResolvedType().isSingleUnderlyingClass(fAllowInterface);
    }

    @Override
    public boolean isExplicitClassIdentity(boolean fAllowParams) {
        return this.isTypeResolved() && this.getResolvedType().isExplicitClassIdentity(fAllowParams);
    }

    @Override
    public TypeConstant getExplicitClassInto(boolean fResolve) {
        if (this.isTypeResolved()) {
            return this.getResolvedType().getExplicitClassInto(fResolve);
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isIntoMetaData(TypeConstant typeTarget, boolean fStrict) {
        return this.isTypeResolved() && this.getResolvedType().isIntoMetaData(typeTarget, fStrict);
    }

    @Override
    public String getEcstasyClassName() {
        return this.isTypeResolved() ? this.getResolvedType().getEcstasyClassName() : "?";
    }

    @Override
    public TypeConstant resolveConstraints(boolean fPendingOnly) {
        return this.isTypeResolved() ? this.getResolvedType().resolveConstraints(fPendingOnly) : this;
    }

    @Override
    public TypeConstant resolveTypedefs() {
        return this.m_type == null ? this : (this.m_fRecursive ? this.m_type : this.m_type.resolveTypedefs());
    }

    @Override
    public boolean containsGenericParam(String sName) {
        return this.isTypeResolved() && this.getResolvedType().containsGenericParam(sName);
    }

    @Override
    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        return this.isTypeResolved() ? this.getResolvedType().getGenericParamType(sName, listParams) : null;
    }

    @Override
    public boolean containsAutoNarrowing(boolean fAllowVirtChild) {
        return this.isTypeResolved() && this.getResolvedType().containsAutoNarrowing(fAllowVirtChild);
    }

    @Override
    public TypeConstant resolveAutoNarrowing(ConstantPool pool, boolean fRetainParams, TypeConstant typeTarget, IdentityConstant idCtx) {
        return this.isTypeResolved() ? this.getResolvedType().resolveAutoNarrowing(pool, fRetainParams, typeTarget, idCtx) : this;
    }

    @Override
    public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        return this.isTypeResolved() ? this.getResolvedType().resolveGenerics(pool, resolver) : this;
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        return this.isTypeResolved() ? this.getResolvedType().resolveContributedName(sName, access, idMethod, collector) : ComponentResolver.ResolutionResult.POSSIBLE;
    }

    @Override
    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant[] atypeParams) {
        return this.isTypeResolved() ? this.getResolvedType().adoptParameters(pool, atypeParams) : this;
    }

    @Override
    public TypeConstant[] collectGenericParameters() {
        return this.isTypeResolved() ? this.getResolvedType().collectGenericParameters() : null;
    }

    @Override
    public TypeConstant.Relation calculateRelation(TypeConstant typeLeft) {
        return this.isTypeResolved() ? this.getResolvedType().calculateRelation(typeLeft) : TypeConstant.Relation.INCOMPATIBLE;
    }

    @Override
    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        return this.isTypeResolved() && this.getResolvedType().containsSubstitutableMethod(signature, access, fFunction, listParams);
    }

    @Override
    public boolean containsFormalType(boolean fAllowParams) {
        return this.isTypeResolved() && this.getResolvedType().containsFormalType(fAllowParams);
    }

    @Override
    public boolean containsGenericType(boolean fAllowParams) {
        return this.isTypeResolved() && this.getResolvedType().containsGenericType(fAllowParams);
    }

    @Override
    public boolean consumesFormalType(String sTypeName, Constants.Access access) {
        return this.isTypeResolved() && this.getResolvedType().consumesFormalType(sTypeName, access);
    }

    @Override
    protected TypeConstant.Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return this.isTypeResolved() ? this.getResolvedType().checkConsumption(sTypeName, access, listParams) : TypeConstant.Usage.NO;
    }

    @Override
    public boolean producesFormalType(String sTypeName, Constants.Access access) {
        return this.isTypeResolved() && this.getResolvedType().producesFormalType(sTypeName, access);
    }

    @Override
    protected TypeConstant.Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return this.isTypeResolved() ? this.getResolvedType().checkProduction(sTypeName, access, listParams) : TypeConstant.Usage.NO;
    }

    @Override
    public boolean isIntoPropertyType() {
        return this.isTypeResolved() && this.getResolvedType().isIntoPropertyType();
    }

    @Override
    public boolean isIntoVariableType() {
        return this.isTypeResolved() && this.getResolvedType().isIntoVariableType();
    }

    @Override
    public TypeInfo getTypeInfo() {
        if (this.isTypeResolved()) {
            return this.getResolvedType().getTypeInfo();
        }
        throw new IllegalStateException();
    }

    @Override
    public TypeInfo ensureTypeInfo(IdentityConstant idClass, ErrorListener errs) {
        if (this.isTypeResolved()) {
            return this.getResolvedType().ensureTypeInfo(idClass, errs);
        }
        throw new IllegalStateException();
    }

    @Override
    public TypeInfo ensureTypeInfo(ErrorListener errs) {
        if (this.isTypeResolved()) {
            return this.getResolvedType().ensureTypeInfo(errs);
        }
        throw new IllegalStateException();
    }

    @Override
    protected TypeInfo buildTypeInfo(ErrorListener errs) {
        if (this.isTypeResolved()) {
            return this.getResolvedType().ensureTypeInfoInternal(errs);
        }
        throw new IllegalStateException();
    }

    @Override
    public Constant.Format getFormat() {
        return this.isTypeResolved() ? this.getResolvedType().getFormat() : Constant.Format.UnresolvedType;
    }

    @Override
    public boolean isClass() {
        return this.isTypeResolved() && this.getResolvedType().isClass();
    }

    @Override
    public boolean containsUnresolved() {
        return !this.m_fRecursive && (this.m_type == null || this.m_type.containsUnresolved());
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        if (this.isTypeResolved()) {
            visitor.accept(this.getResolvedType());
        }
    }

    @Override
    protected void setPosition(int iPos) {
        throw new IllegalStateException("unresolved: " + String.valueOf(this));
    }

    @Override
    public String getValueString() {
        return this.isTypeResolved() ? this.getResolvedType().getValueString() : this.m_constId.getValueString();
    }

    @Override
    protected int compareDetails(Constant that) {
        that = that.resolve();
        if (this.isTypeResolved()) {
            return this.getResolvedType().compareDetails(that);
        }
        if (that instanceof UnresolvedTypeConstant) {
            UnresolvedTypeConstant thatUnresolved = (UnresolvedTypeConstant)that;
            return this.m_constId.compareDetails(thatUnresolved.m_constId);
        }
        return this == that ? 0 : -1;
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        throw new IllegalStateException();
    }

    @Override
    protected void assemble(DataOutput out) {
        throw new IllegalStateException(this.toString());
    }

    @Override
    public boolean validate(ErrorListener errs) {
        if (this.isTypeResolved()) {
            return this.getResolvedType().validate(errs);
        }
        errs.log(Severity.ERROR, "COMPILER-38", new Object[]{this.getValueString()}, this);
        return true;
    }

    @Override
    public String getDescription() {
        return this.isTypeResolved() ? "(resolved) " + this.getResolvedType().getDescription() : this.m_constId.getDescription();
    }

    @Override
    public int hashCode() {
        if (this.isTypeResolved()) {
            return Hash.of(this.getResolvedType());
        }
        int nHash = this.m_nUnresolvedHash;
        if (nHash == 0) {
            nHash = Hash.of(this.m_constId);
            if (nHash == 0) {
                nHash = 1234567891;
            }
            this.m_nUnresolvedHash = nHash;
        }
        return nHash;
    }

    @Override
    public int computeHashCode() {
        return 0;
    }
}

