/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Version;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.TypeConstant;

public class VersionConstant
extends LiteralConstant {
    private Version m_ver;

    public VersionConstant(ConstantPool pool, Version ver) {
        super(pool, Constant.Format.Version, ver.toString(), null);
        this.m_ver = ver;
    }

    public VersionConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    @Override
    protected void resolveConstants() {
        super.resolveConstants();
        this.m_ver = new Version(this.getValue());
    }

    public Version getVersion() {
        return this.m_ver;
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().typeVersion();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof VersionConstant)) {
            return -1;
        }
        return this.m_ver.compareTo(((VersionConstant)that).m_ver);
    }

    @Override
    public String getValueString() {
        return "v:" + this.getValue();
    }

    @Override
    public String getDescription() {
        return "version=" + this.getValue();
    }
}

