/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.Version;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.PresentCondition;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class VersionMatchesCondition
extends ConditionalConstant {
    private transient int m_iModule;
    private transient int m_iVer;
    private ModuleConstant m_constStruct;
    private VersionConstant m_constVer;

    public VersionMatchesCondition(ConstantPool pool, ModuleConstant constModule, VersionConstant constVer) {
        super(pool);
        this.m_constStruct = constModule;
        this.m_constVer = constVer;
    }

    public VersionMatchesCondition(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iModule = Handy.readMagnitude(in);
        this.m_iVer = Handy.readIndex(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constStruct = (ModuleConstant)pool.getConstant(this.m_iModule);
        this.m_constVer = (VersionConstant)pool.getConstant(this.m_iVer);
    }

    public ModuleConstant getModuleConstant() {
        return this.m_constStruct;
    }

    public VersionConstant getVersionConstant() {
        return this.m_constVer;
    }

    @Override
    public boolean evaluate(LinkerContext ctx) {
        return ctx.isVersionMatch(this.m_constStruct, this.m_constVer);
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public ConditionalConstant.Relation calcRelation(ConditionalConstant constant) {
        if (constant instanceof VersionMatchesCondition) {
            VersionMatchesCondition that = (VersionMatchesCondition)constant;
            if (this.m_constStruct.equals(that.m_constStruct)) {
                Version verThat;
                Version verThis = this.m_constVer.getVersion();
                if (verThis.isSameAs(verThat = that.m_constVer.getVersion())) {
                    return ConditionalConstant.Relation.EQUIV;
                }
                if (verThis.isSubstitutableFor(verThat)) {
                    return ConditionalConstant.Relation.IMPLIES;
                }
                if (verThat.isSubstitutableFor(verThis)) {
                    return ConditionalConstant.Relation.IMPLIED;
                }
                return ConditionalConstant.Relation.MUTEX;
            }
        } else if (constant instanceof PresentCondition) {
            return constant.calcRelation(this).reverse();
        }
        return ConditionalConstant.Relation.INDEP;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ConditionVersionMatches;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constStruct.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constStruct);
        visitor.accept(this.m_constVer);
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof VersionMatchesCondition)) {
            return -1;
        }
        VersionMatchesCondition that = (VersionMatchesCondition)obj;
        int nResult = this.m_constStruct.compareTo(that.m_constStruct);
        if (nResult == 0) {
            nResult = this.m_constVer.compareTo(that.m_constVer);
        }
        return nResult;
    }

    @Override
    public String getValueString() {
        return "versionMatches(" + String.valueOf(this.m_constStruct) + ", " + this.m_constVer.getValueString() + ")";
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constStruct = (ModuleConstant)pool.register(this.m_constStruct);
        this.m_constVer = (VersionConstant)pool.register(this.m_constVer);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constStruct.getPosition());
        Handy.writePackedLong(out, this.m_constVer.getPosition());
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constStruct, Hash.of(this.m_constVer));
    }
}

