/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.Version;
import org.xvm.asm.constants.AnyCondition;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class VersionedCondition
extends ConditionalConstant {
    private transient int m_iVer;
    private VersionConstant m_constVer;

    public VersionedCondition(ConstantPool pool, VersionConstant constVer) {
        super(pool);
        this.m_constVer = constVer;
    }

    public VersionedCondition(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iVer = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constVer = (VersionConstant)this.getConstantPool().getConstant(this.m_iVer);
    }

    public Version getVersion() {
        return this.m_constVer.getVersion();
    }

    public VersionConstant getVersionConstant() {
        return this.m_constVer;
    }

    @Override
    public boolean evaluate(LinkerContext ctx) {
        return ctx.isVersion(this.m_constVer);
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public Set<Version> versions() {
        return Collections.singleton(this.m_constVer.getVersion());
    }

    @Override
    public ConditionalConstant addVersion(Version ver) {
        if (ver.equals(this.getVersion())) {
            return this;
        }
        ConstantPool pool = this.getConstantPool();
        return new AnyCondition(pool, this, pool.ensureVersionedCondition(ver));
    }

    @Override
    public ConditionalConstant removeVersion(Version ver) {
        return ver.equals(this.getVersion()) ? null : this;
    }

    @Override
    public ConditionalConstant.Relation calcRelation(ConditionalConstant that) {
        if (that instanceof VersionedCondition) {
            Version verThat;
            Version verThis = this.m_constVer.getVersion();
            return verThis.isSameAs(verThat = ((VersionedCondition)that).m_constVer.getVersion()) ? ConditionalConstant.Relation.EQUIV : ConditionalConstant.Relation.MUTEX;
        }
        return ConditionalConstant.Relation.INDEP;
    }

    @Override
    protected boolean isTerminalInfluenceFinessable(boolean fInNot, Set<ConditionalConstant> setSimple, Set<ConditionalConstant> setComplex) {
        return !fInNot && super.isTerminalInfluenceFinessable(fInNot, setSimple, setComplex);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ConditionVersioned;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constVer);
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof VersionedCondition)) {
            return -1;
        }
        VersionedCondition constThat = (VersionedCondition)that;
        return this.m_constVer.compareTo(constThat.m_constVer);
    }

    @Override
    public String getValueString() {
        return "isVersion(" + this.m_constVer.getValueString() + ")";
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constVer = (VersionConstant)pool.register(this.m_constVer);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constVer.getPosition());
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constVer);
    }
}

