/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.AbstractDependantChildTypeConstant;
import org.xvm.asm.constants.AccessTypeConstant;
import org.xvm.asm.constants.ChildInfo;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.ImmutableTypeConstant;
import org.xvm.asm.constants.IntersectionTypeConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class VirtualChildTypeConstant
extends AbstractDependantChildTypeConstant {
    private transient int m_iName;
    protected StringConstant m_constName;
    protected boolean m_fThisClass;
    private transient TypeConstant m_typeOriginParent;
    private transient ClassStructure m_clzChild;

    public VirtualChildTypeConstant(ConstantPool pool, TypeConstant typeParent, String sName, boolean fThisClass) {
        super(pool, typeParent);
        if (sName == null) {
            throw new IllegalArgumentException("name is required");
        }
        this.m_constName = pool.ensureStringConstant(sName);
        this.m_fThisClass = fThisClass;
        this.m_typeOriginParent = this.m_typeParent;
    }

    public VirtualChildTypeConstant(ConstantPool pool, TypeConstant typeParent, String sName, TypeConstant typeOriginParent) {
        super(pool, typeParent);
        if (typeParent.isAnnotated()) {
            throw new IllegalArgumentException("parent's annotations cannot be specified");
        }
        if (sName == null) {
            throw new IllegalArgumentException("name is required");
        }
        if (!typeOriginParent.isA(typeParent)) {
            throw new IllegalArgumentException("origin parent must extend the parent");
        }
        this.m_constName = pool.ensureStringConstant(sName);
        this.m_fThisClass = false;
        this.m_typeOriginParent = typeOriginParent;
    }

    public VirtualChildTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
        this.m_iName = Handy.readIndex(in);
        this.m_fThisClass = in.readBoolean();
    }

    @Override
    protected void resolveConstants() {
        super.resolveConstants();
        this.m_constName = (StringConstant)this.getConstantPool().getConstant(this.m_iName);
        this.m_typeOriginParent = this.m_typeParent;
    }

    public String getChildName() {
        return this.m_constName.getValue();
    }

    @Override
    protected ClassStructure getChildStructure() {
        Component child;
        ClassStructure clzChild;
        ClassStructure parent;
        if (this.m_clzChild != null) {
            return this.m_clzChild;
        }
        TypeConstant typeParent = this.getParentType();
        String sChild = this.getChildName();
        if (typeParent.isSingleUnderlyingClass(true) && (parent = (ClassStructure)typeParent.getSingleUnderlyingClass(true).getComponent()) != null && (clzChild = (ClassStructure)parent.findChildDeep(sChild)) != null) {
            this.m_clzChild = clzChild;
            return this.m_clzChild;
        }
        ChildInfo info = typeParent.ensureTypeInfo().getChildInfosByName().get(sChild);
        if (info != null && (child = info.getComponent()) instanceof ClassStructure) {
            ClassStructure clzChild2;
            this.m_clzChild = clzChild2 = (ClassStructure)child;
            return this.m_clzChild;
        }
        throw new IllegalStateException("unknown child " + sChild + " of type " + String.valueOf(typeParent));
    }

    @Override
    public boolean isVirtualChild() {
        return true;
    }

    @Override
    public TypeConstant getOriginParentType() {
        return this.m_typeOriginParent;
    }

    @Override
    public boolean isPhantom() {
        TypeConstant typeParent = this.m_typeParent;
        if (typeParent.isVirtualChild() && typeParent.isPhantom()) {
            return true;
        }
        ClassStructure parent = (ClassStructure)typeParent.getSingleUnderlyingClass(true).getComponent();
        return parent.getChild(this.getChildName()) == null;
    }

    @Override
    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        return this.m_fThisClass ? pool.ensureThisVirtualChildTypeConstant(type, this.m_constName.getValue()) : pool.ensureVirtualChildTypeConstant(type, this.m_constName.getValue());
    }

    @Override
    public boolean containsAutoNarrowing(boolean fAllowVirtChild) {
        return fAllowVirtChild && this.m_fThisClass || this.m_typeParent.containsAutoNarrowing(false);
    }

    @Override
    public boolean isAutoNarrowing() {
        return this.m_fThisClass;
    }

    @Override
    public TypeConstant ensureAutoNarrowing() {
        return this.m_fThisClass ? this : this.getConstantPool().ensureThisVirtualChildTypeConstant(this.m_typeParent, this.m_constName.getValue());
    }

    @Override
    public TypeConstant resolveAutoNarrowing(ConstantPool pool, boolean fRetainParams, TypeConstant typeTarget, IdentityConstant idCtx) {
        TypeConstant typeParentOriginal;
        TypeConstant typeParentResolved = typeParentOriginal = this.m_typeParent;
        if (typeParentOriginal.containsAutoNarrowing(false)) {
            typeParentResolved = typeParentOriginal.resolveAutoNarrowing(pool, fRetainParams, typeTarget, idCtx);
        } else if (typeTarget != null && this.m_fThisClass) {
            while (typeTarget instanceof ImmutableTypeConstant || typeTarget instanceof AccessTypeConstant) {
                typeTarget = typeTarget.getUnderlyingType();
            }
            if (typeTarget.isA(this)) {
                return typeTarget;
            }
            if (typeTarget.isA(typeParentOriginal)) {
                typeParentResolved = typeTarget;
            }
        }
        return typeParentOriginal == typeParentResolved ? this : (this.m_fThisClass ? pool.ensureThisVirtualChildTypeConstant(typeParentResolved, this.m_constName.getValue()) : pool.ensureVirtualChildTypeConstant(typeParentResolved, this.m_constName.getValue()));
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        TypeConstant typeParent = this.getParentType();
        if (typeParent instanceof IntersectionTypeConstant) {
            IntersectionTypeConstant typeInter = (IntersectionTypeConstant)typeParent;
            typeParent = typeInter.extractParent(this.getChildName());
            return this.cloneSingle(this.getConstantPool(), typeParent).calculateRelation(typeLeft);
        }
        return super.calculateRelationToLeft(typeLeft);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.VirtualChildType;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        super.forEachUnderlying(visitor);
        visitor.accept(this.m_constName);
    }

    @Override
    protected int compareDetails(Constant obj) {
        int n = super.compareDetails(obj);
        if (n == 0) {
            if (!(obj instanceof VirtualChildTypeConstant)) {
                return -1;
            }
            VirtualChildTypeConstant that = (VirtualChildTypeConstant)obj;
            n = this.m_constName.compareTo(that.m_constName);
            if (n == 0 && (this.m_typeParent == this.m_typeOriginParent && that.m_typeParent == that.m_typeOriginParent || (n = this.m_typeOriginParent.compareDetails(that.m_typeOriginParent)) == 0)) {
                n = Boolean.compare(this.m_fThisClass, that.m_fThisClass);
            }
        }
        return n;
    }

    @Override
    public String getValueString() {
        return (this.m_fThisClass ? "this:" : "") + (this.m_typeParent == this.m_typeOriginParent ? "" : "virtual ") + this.m_typeOriginParent.getValueString() + "." + this.m_constName.getValue();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        this.m_constName = (StringConstant)pool.register(this.m_constName);
        this.m_typeOriginParent = (TypeConstant)pool.register(this.m_typeOriginParent);
        this.m_clzChild = null;
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        assert (this.m_typeOriginParent == this.m_typeParent);
        super.assemble(out);
        Handy.writePackedLong(out, this.m_constName.getPosition());
        out.writeBoolean(this.m_fThisClass);
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_typeParent, Hash.of(this.m_constName, Hash.of(this.m_fThisClass)));
    }
}

