/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.Label;
import java.lang.constant.ConstantDesc;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.javajit.Builder;
import org.xvm.javajit.Ctx;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.util.Handy;

public class Assert
extends Op {
    private int m_nTest;
    private int m_nConstructor = -2;
    private Argument m_argTest;
    private MethodConstant m_idConstruct;

    public Assert(Argument argTest, MethodConstant idConstruct) {
        this.m_argTest = argTest;
        this.m_idConstruct = idConstruct;
    }

    public Assert(DataInput in, Constant[] aconst) throws IOException {
        this.m_nTest = Handy.readPackedInt(in);
        this.m_nConstructor = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTest != null) {
            this.m_nTest = Assert.encodeArgument(this.m_argTest, registry);
        }
        if (this.m_idConstruct != null) {
            this.m_nConstructor = Assert.encodeArgument(this.m_idConstruct, registry);
        }
        Handy.writePackedLong(out, this.m_nTest);
        Handy.writePackedLong(out, this.m_nConstructor);
    }

    @Override
    public int getOpCode() {
        return 144;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hValue = frame.getArgument(this.m_nTest);
            return Assert.isDeferred(hValue) ? hValue.proceed(frame, frameCaller -> this.evaluate(frameCaller, iPC, (xBoolean.BooleanHandle)frameCaller.popStack())) : this.evaluate(frame, iPC, (xBoolean.BooleanHandle)hValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int evaluate(Frame frame, int iPC, xBoolean.BooleanHandle hTest) {
        if (hTest.get()) {
            return iPC + 1;
        }
        String sMsg = this.buildMessage(frame);
        return this.complete(frame, iPC, sMsg);
    }

    protected int complete(Frame frame, int iPC, String sMsg) {
        if (this.m_nConstructor == -2) {
            return frame.f_context.getDebugger().activate(frame, iPC);
        }
        MethodConstant idConstruct = (MethodConstant)frame.getConstant(this.m_nConstructor);
        MethodStructure construct = (MethodStructure)idConstruct.getComponent();
        ClassConstant constClz = (ClassConstant)idConstruct.getNamespace();
        ClassTemplate template = frame.ensureTemplate(constClz);
        ClassComposition clzTarget = template.getCanonicalClass(frame.f_context.f_container);
        xString.StringHandle hMsg = xString.makeHandle(sMsg);
        ObjectHandle[] ahArg = new ObjectHandle[construct.getMaxVars()];
        ahArg[0] = hMsg;
        switch (template.construct(frame, construct, clzTarget, null, ahArg, -1)) {
            case -1: {
                return frame.raiseException((ObjectHandle.ExceptionHandle)frame.popStack());
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> frameCaller.raiseException((ObjectHandle.ExceptionHandle)frameCaller.popStack()));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    protected String buildMessage(Frame frame) {
        return "Assertion failed";
    }

    @Override
    public boolean advances() {
        return !(this.m_argTest instanceof Constant) || !this.m_argTest.equals(((Constant)this.m_argTest).getConstantPool().valFalse());
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argTest = Assert.registerArgument(this.m_argTest, registry);
        this.m_idConstruct = (MethodConstant)Assert.registerArgument(this.m_idConstruct, registry);
    }

    @Override
    public String toString() {
        return super.toString() + " " + Argument.toIdString(this.m_argTest, this.m_nTest);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        Label labelEnd = code.newLabel();
        bctx.loadArgument(code, this.m_nTest);
        code.ifne(labelEnd);
        bctx.loadCtx(code);
        if (this.m_nConstructor == -2) {
            code.loadConstant((ConstantDesc)((Object)"Debugger support for jit is not yet implemented"));
            code.invokevirtual(Builder.CD_Ctx, "log", Ctx.MD_log);
        } else {
            this.buildMessage(bctx, code);
            code.invokevirtual(Builder.CD_Ctx, "log", Ctx.MD_log);
        }
        code.labelBinding(labelEnd);
    }

    protected void buildMessage(BuildContext bctx, CodeBuilder code) {
        code.loadConstant((ConstantDesc)((Object)"Assertion failed"));
    }
}

