/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.op.Assert;
import org.xvm.runtime.Frame;
import org.xvm.util.Handy;

public class AssertM
extends Assert {
    protected int m_nMsgConstId;
    private StringConstant m_constMsg;

    public AssertM(Argument argTest, MethodConstant constructor, StringConstant constMsg) {
        super(argTest, constructor);
        this.m_constMsg = constMsg;
    }

    public AssertM(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nMsgConstId = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_constMsg != null) {
            this.m_nMsgConstId = AssertM.encodeArgument(this.m_constMsg, registry);
        }
        Handy.writePackedLong(out, this.m_nMsgConstId);
    }

    @Override
    public int getOpCode() {
        return 145;
    }

    @Override
    protected String buildMessage(Frame frame) {
        return frame.getString(this.m_nMsgConstId);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_constMsg = (StringConstant)AssertM.registerArgument(this.m_constMsg, registry);
    }

    @Override
    public String toString() {
        return super.toString() + " " + Argument.toIdString(this.m_constMsg, this.m_nMsgConstId);
    }
}

