/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.op.AssertM;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;

public class AssertV
extends AssertM {
    private int[] m_anValue;
    private Argument[] m_aArgValue;
    private volatile transient String[] m_asParts;

    public AssertV(Argument argTest, MethodConstant constructor, StringConstant constMsg, Argument[] aArgValue) {
        super(argTest, constructor, constMsg);
        this.m_aArgValue = aArgValue;
    }

    public AssertV(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anValue = AssertV.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anValue = AssertV.encodeArguments(this.m_aArgValue, registry);
        }
        AssertV.writeIntArray(out, this.m_anValue);
    }

    @Override
    public int getOpCode() {
        return 146;
    }

    @Override
    protected int evaluate(Frame frame, int iPC, xBoolean.BooleanHandle hTest) {
        if (hTest.get()) {
            return iPC + 1;
        }
        if (this.m_asParts == null) {
            String sMsg = frame.getString(this.m_nMsgConstId);
            int cVals = this.m_anValue.length;
            String[] asParts = new String[cVals + 1];
            for (int i = 0; i < cVals; ++i) {
                String sReplace = "{" + i + "}";
                int of = sMsg.indexOf(sReplace);
                if (of > 0) {
                    asParts[i] = sMsg.substring(0, of);
                    sMsg = sMsg.substring(of + sReplace.length());
                    continue;
                }
                asParts[i] = "";
            }
            assert (sMsg != null);
            asParts[cVals] = sMsg;
            this.m_asParts = asParts;
        }
        int cArgs = this.m_anValue.length;
        ObjectHandle[] ahArg = new ObjectHandle[cArgs];
        for (int i = 0; i < cArgs; ++i) {
            try {
                ahArg[i] = frame.getArgument(this.m_anValue[i]);
                continue;
            }
            catch (Exception e) {
                ahArg[i] = xString.EMPTY_STRING;
            }
        }
        StringBuilder sb = new StringBuilder(this.m_asParts[0]);
        Frame.Continuation doComplete = frameCaller -> this.complete(frameCaller, iPC, sb.toString());
        return new MessageToString(sb, ahArg, this.m_asParts, doComplete).doNext(frame);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        AssertV.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" (");
        int c = Math.max(this.m_anValue == null ? 0 : this.m_anValue.length, this.m_aArgValue == null ? 0 : this.m_aArgValue.length);
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Argument.toIdString(this.m_aArgValue == null ? null : this.m_aArgValue[i], this.m_anValue == null ? 1000000000 : this.m_anValue[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    private static class MessageToString
    implements Frame.Continuation {
        protected static final int MAX_VAL = 2048;
        protected static final int MAX_LEN = 16384;
        protected final StringBuilder sb;
        protected final ObjectHandle[] ahValue;
        protected final String[] asLabel;
        protected final Frame.Continuation nextStep;
        protected int index = -1;

        public MessageToString(StringBuilder sb, ObjectHandle[] ahValue, String[] asLabel, Frame.Continuation nextStep) {
            this.sb = sb;
            this.ahValue = ahValue;
            this.asLabel = asLabel;
            this.nextStep = nextStep;
        }

        protected int doNext(Frame frameCaller) {
            block4: while (++this.index < this.ahValue.length) {
                switch (Utils.callValueOf(frameCaller, this.ahValue[this.index])) {
                    case -1: {
                        if (!this.updateResult(frameCaller)) break block4;
                        continue block4;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            return this.nextStep.proceed(frameCaller);
        }

        @Override
        public int proceed(Frame frameCaller) {
            if (this.updateResult(frameCaller)) {
                return this.doNext(frameCaller);
            }
            return this.nextStep.proceed(frameCaller);
        }

        protected boolean updateResult(Frame frameCaller) {
            xString.StringHandle hMsg = (xString.StringHandle)frameCaller.popStack();
            char[] ach = hMsg.getValue();
            if (ach.length > 2048) {
                this.sb.append(ach, 0, 2048).append("...");
            } else {
                this.sb.append(ach);
            }
            if (this.sb.length() > 16384) {
                this.sb.append("...");
                return false;
            }
            this.sb.append(this.asLabel[this.index + 1]);
            return true;
        }
    }
}

