/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.util.Handy;

public class Call_01
extends OpCallable {
    public Call_01(Argument argFunction, Argument argReturn) {
        super(argFunction);
        this.m_argReturn = argReturn;
    }

    public Call_01(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argReturn != null) {
            this.m_nRetValue = Call_01.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 17;
    }

    @Override
    public int process(Frame frame, int iPC) {
        if (this.m_nFunctionId == -13) {
            CallChain chain = frame.m_chain;
            if (chain == null) {
                throw new IllegalStateException();
            }
            MethodStructure method = chain.getSuper(frame);
            if (method == null) {
                if (frame.isNextRegister(this.m_nRetValue)) {
                    frame.introduceResolvedVar(this.m_nRetValue, chain.getProperty().getType());
                }
            } else {
                this.checkReturnRegister(frame, method);
            }
            return chain.callSuper01(frame, this.m_nRetValue);
        }
        if (this.m_nFunctionId <= -16) {
            MethodStructure function = this.getMethodStructure(frame);
            if (function == null) {
                return -3;
            }
            this.checkReturnRegister(frame, function);
            if (function.isNative()) {
                return this.getNativeTemplate(frame, function).invokeNativeN(frame, function, null, Utils.OBJECTS_NONE, this.m_nRetValue);
            }
            ObjectHandle[] ahVar = new ObjectHandle[function.getMaxVars()];
            return frame.call1(function, null, ahVar, this.m_nRetValue);
        }
        try {
            ObjectHandle hFunction = frame.getArgument(this.m_nFunctionId);
            return Call_01.isDeferred(hFunction) ? hFunction.proceed(frame, frameCaller -> this.complete(frameCaller, (xRTFunction.FunctionHandle)frameCaller.popStack())) : this.complete(frame, (xRTFunction.FunctionHandle)hFunction);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    private int complete(Frame frame, xRTFunction.FunctionHandle hFunction) {
        this.checkReturnRegister(frame, hFunction.getMethod());
        return hFunction.call1(frame, null, new ObjectHandle[hFunction.getVarCount()], this.m_nRetValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildCall(bctx, code, NO_ARGS);
    }
}

