/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;

public class Call_0N
extends OpCallable {
    public Call_0N(Argument argFunction, Argument[] aArgReturn) {
        super(argFunction);
        this.m_aArgReturn = aArgReturn;
    }

    public Call_0N(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anRetValue = Call_0N.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgReturn != null) {
            this.m_anRetValue = Call_0N.encodeArguments(this.m_aArgReturn, registry);
        }
        Call_0N.writeIntArray(out, this.m_anRetValue);
    }

    @Override
    public int getOpCode() {
        return 18;
    }

    @Override
    protected boolean isMultiReturn() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        if (this.m_nFunctionId == -13) {
            CallChain chain = frame.m_chain;
            if (chain == null) {
                throw new IllegalStateException();
            }
            this.checkReturnRegisters(frame, chain.getSuper(frame));
            return chain.callSuperNN(frame, Utils.OBJECTS_NONE, this.m_anRetValue);
        }
        if (this.m_nFunctionId <= -16) {
            MethodStructure function = this.getMethodStructure(frame);
            if (function == null) {
                return -3;
            }
            this.checkReturnRegisters(frame, function);
            if (function.isNative()) {
                return this.getNativeTemplate(frame, function).invokeNativeNN(frame, function, null, Utils.OBJECTS_NONE, this.m_anRetValue);
            }
            ObjectHandle[] ahVar = new ObjectHandle[function.getMaxVars()];
            return frame.callN(function, null, ahVar, this.m_anRetValue);
        }
        try {
            ObjectHandle hFunction = frame.getArgument(this.m_nFunctionId);
            return Call_0N.isDeferred(hFunction) ? hFunction.proceed(frame, frameCaller -> this.complete(frameCaller, (xRTFunction.FunctionHandle)frameCaller.popStack())) : this.complete(frame, (xRTFunction.FunctionHandle)hFunction);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    private int complete(Frame frame, xRTFunction.FunctionHandle hFunction) {
        this.checkReturnRegisters(frame, hFunction.getMethod());
        return hFunction.callN(frame, null, Utils.OBJECTS_NONE, this.m_anRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Call_0N.registerArguments(this.m_aArgReturn, registry);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildCall(bctx, code, NO_ARGS);
    }
}

