/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.util.Handy;

public class Call_0T
extends OpCallable {
    public Call_0T(Argument argFunction, Argument argReturn) {
        super(argFunction);
        this.m_argReturn = argReturn;
    }

    public Call_0T(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argReturn != null) {
            this.m_nRetValue = Call_0T.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 19;
    }

    @Override
    public int process(Frame frame, int iPC) {
        if (this.m_nFunctionId == -13) {
            CallChain chain = frame.m_chain;
            if (chain == null) {
                throw new IllegalStateException();
            }
            this.checkReturnTupleRegister(frame, chain.getSuper(frame));
            switch (chain.callSuper01(frame, -1)) {
                case -1: {
                    return frame.assignTuple(this.m_nRetValue, frame.popStack());
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignTuple(this.m_nRetValue, frameCaller.popStack()));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        if (this.m_nFunctionId <= -16) {
            MethodStructure function = this.getMethodStructure(frame);
            if (function == null) {
                return -3;
            }
            this.checkReturnTupleRegister(frame, function);
            if (function.isNative()) {
                return this.getNativeTemplate(frame, function).invokeNativeT(frame, function, null, Utils.OBJECTS_NONE, this.m_nRetValue);
            }
            ObjectHandle[] ahVar = new ObjectHandle[function.getMaxVars()];
            return frame.callT(function, null, ahVar, this.m_nRetValue);
        }
        try {
            ObjectHandle hFunction = frame.getArgument(this.m_nFunctionId);
            return Call_0T.isDeferred(hFunction) ? hFunction.proceed(frame, frameCaller -> this.complete(frameCaller, (xRTFunction.FunctionHandle)frameCaller.popStack())) : this.complete(frame, (xRTFunction.FunctionHandle)hFunction);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    private int complete(Frame frame, xRTFunction.FunctionHandle hFunction) {
        this.checkReturnTupleRegister(frame, hFunction.getMethod());
        return hFunction.callT(frame, null, new ObjectHandle[hFunction.getVarCount()], this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argReturn = Call_0T.registerArgument(this.m_argReturn, registry);
    }
}

