/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.util.Handy;

public class Call_10
extends OpCallable {
    private int m_nArgValue;
    private Argument m_argValue;

    public Call_10(Argument argFunction, Argument argValue) {
        super(argFunction);
        this.m_argValue = argValue;
    }

    public Call_10(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgValue = Call_10.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nArgValue);
    }

    @Override
    public int getOpCode() {
        return 20;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nArgValue);
            if (this.m_nFunctionId == -13) {
                CallChain chain = frame.m_chain;
                if (chain == null) {
                    throw new IllegalStateException();
                }
                return Call_10.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> chain.callSuper11(frameCaller, frameCaller.popStack(), -2)) : chain.callSuper11(frame, hArg, -2);
            }
            if (this.m_nFunctionId <= -16) {
                MethodStructure function = this.getMethodStructure(frame);
                if (function == null) {
                    return -3;
                }
                return Call_10.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, frameCaller.popStack(), function)) : this.complete(frame, hArg, function);
            }
            ObjectHandle hFunction = frame.getArgument(this.m_nFunctionId);
            if (Call_10.isDeferred(hArg) || Call_10.isDeferred(hFunction)) {
                ObjectHandle[] ahArg = new ObjectHandle[]{hArg, hFunction};
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, ahArg[0], (xRTFunction.FunctionHandle)ahArg[1]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.complete(frame, hArg, (xRTFunction.FunctionHandle)hFunction);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hArg, MethodStructure function) {
        if (function.isNative()) {
            return this.getNativeTemplate(frame, function).invokeNative1(frame, function, null, hArg, -2);
        }
        ObjectHandle[] ahVar = new ObjectHandle[function.getMaxVars()];
        ahVar[0] = hArg;
        return frame.call1(function, null, ahVar, -2);
    }

    protected int complete(Frame frame, ObjectHandle hArg, xRTFunction.FunctionHandle hFunction) {
        ObjectHandle[] ahVar = new ObjectHandle[hFunction.getVarCount()];
        ahVar[0] = hArg;
        return hFunction.call1(frame, null, ahVar, -2);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Call_10.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildCall(bctx, code, new int[]{this.m_nArgValue});
    }
}

