/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.util.Handy;

public class Call_1N
extends OpCallable {
    private int m_nArgValue;
    private Argument m_argValue;

    public Call_1N(Argument argFunction, Argument argValue, Argument[] aArgReturn) {
        super(argFunction);
        this.m_argValue = argValue;
        this.m_aArgReturn = aArgReturn;
    }

    public Call_1N(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgValue = Handy.readPackedInt(in);
        this.m_anRetValue = Call_1N.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgValue = Call_1N.encodeArgument(this.m_argValue, registry);
            this.m_anRetValue = Call_1N.encodeArguments(this.m_aArgReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nArgValue);
        Call_1N.writeIntArray(out, this.m_anRetValue);
    }

    @Override
    public int getOpCode() {
        return 22;
    }

    @Override
    protected boolean isMultiReturn() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nArgValue);
            if (this.m_nFunctionId == -13) {
                CallChain chain = frame.m_chain;
                if (chain == null) {
                    throw new IllegalStateException();
                }
                this.checkReturnRegisters(frame, chain.getSuper(frame));
                ObjectHandle[] ahArg = new ObjectHandle[]{hArg};
                if (Call_1N.isDeferred(hArg)) {
                    Frame.Continuation stepNext = frameCaller -> chain.callSuperNN(frame, ahArg, this.m_anRetValue);
                    return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
                }
                return chain.callSuperNN(frame, ahArg, this.m_anRetValue);
            }
            if (this.m_nFunctionId <= -16) {
                MethodStructure function = this.getMethodStructure(frame);
                if (function == null) {
                    return -3;
                }
                return Call_1N.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, frameCaller.popStack(), function)) : this.complete(frame, hArg, function);
            }
            ObjectHandle hFunction = frame.getArgument(this.m_nFunctionId);
            if (Call_1N.isDeferred(hArg) || Call_1N.isDeferred(hFunction)) {
                ObjectHandle[] ahArg = new ObjectHandle[]{hArg, hFunction};
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, ahArg[0], (xRTFunction.FunctionHandle)ahArg[1]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.complete(frame, hArg, (xRTFunction.FunctionHandle)hFunction);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hArg, MethodStructure function) {
        this.checkReturnRegisters(frame, function);
        if (function.isNative()) {
            return this.getNativeTemplate(frame, function).invokeNativeNN(frame, function, null, new ObjectHandle[]{hArg}, this.m_anRetValue);
        }
        ObjectHandle[] ahVar = new ObjectHandle[function.getMaxVars()];
        ahVar[0] = hArg;
        return frame.callN(function, null, ahVar, this.m_anRetValue);
    }

    protected int complete(Frame frame, ObjectHandle hArg, xRTFunction.FunctionHandle hFunction) {
        this.checkReturnRegisters(frame, hFunction.getMethod());
        ObjectHandle[] ahVar = new ObjectHandle[hFunction.getVarCount()];
        ahVar[0] = hArg;
        return hFunction.callN(frame, null, ahVar, this.m_anRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Call_1N.registerArgument(this.m_argValue, registry);
        Call_1N.registerArguments(this.m_aArgReturn, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildCall(bctx, code, new int[]{this.m_nArgValue});
    }
}

