/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.util.Handy;

public class Call_1T
extends OpCallable {
    private int m_nArgValue;
    private Argument m_argValue;

    public Call_1T(Argument argFunction, Argument argValue, Argument argReturn) {
        super(argFunction);
        this.m_argValue = argValue;
        this.m_argReturn = argReturn;
    }

    public Call_1T(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgValue = Call_1T.encodeArgument(this.m_argValue, registry);
            this.m_nRetValue = Call_1T.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 23;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nArgValue);
            if (this.m_nFunctionId == -13) {
                CallChain chain = frame.m_chain;
                if (chain == null) {
                    throw new IllegalStateException();
                }
                this.checkReturnTupleRegister(frame, chain.getSuper(frame));
                ObjectHandle[] ahArg = new ObjectHandle[]{hArg};
                if (Call_1T.isDeferred(hArg)) {
                    Frame.Continuation stepNext = frameCaller -> chain.callSuperN1(frame, ahArg, this.m_nRetValue, true);
                    return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
                }
                return chain.callSuperN1(frame, ahArg, this.m_nRetValue, true);
            }
            if (this.m_nFunctionId <= -16) {
                MethodStructure function = this.getMethodStructure(frame);
                if (function == null) {
                    return -3;
                }
                return Call_1T.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, frameCaller.popStack(), function)) : this.complete(frame, hArg, function);
            }
            ObjectHandle hFunction = frame.getArgument(this.m_nFunctionId);
            if (Call_1T.isDeferred(hArg) || Call_1T.isDeferred(hFunction)) {
                ObjectHandle[] ahArg = new ObjectHandle[]{hArg};
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, ahArg[0], (xRTFunction.FunctionHandle)ahArg[1]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.complete(frame, hArg, (xRTFunction.FunctionHandle)hFunction);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hArg, MethodStructure function) {
        this.checkReturnTupleRegister(frame, function);
        if (function.isNative()) {
            return this.getNativeTemplate(frame, function).invokeNativeT(frame, function, null, new ObjectHandle[]{hArg}, this.m_nRetValue);
        }
        ObjectHandle[] ahVar = new ObjectHandle[function.getMaxVars()];
        ahVar[0] = hArg;
        return frame.callT(function, null, ahVar, this.m_nRetValue);
    }

    protected int complete(Frame frame, ObjectHandle hArg, xRTFunction.FunctionHandle hFunction) {
        this.checkReturnTupleRegister(frame, hFunction.getMethod());
        ObjectHandle[] ahVar = new ObjectHandle[hFunction.getVarCount()];
        ahVar[0] = hArg;
        return hFunction.callT(frame, null, ahVar, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Call_1T.registerArgument(this.m_argValue, registry);
        this.m_argReturn = Call_1T.registerArgument(this.m_argReturn, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }
}

