/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;

public class Call_N0
extends OpCallable {
    private int[] m_anArgValue;
    private Argument[] m_aArgValue;

    public Call_N0(Argument argFunction, Argument[] aArgValue) {
        super(argFunction);
        this.m_aArgValue = aArgValue;
    }

    public Call_N0(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anArgValue = Call_N0.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anArgValue = Call_N0.encodeArguments(this.m_aArgValue, registry);
        }
        Call_N0.writeIntArray(out, this.m_anArgValue);
    }

    @Override
    public int getOpCode() {
        return 24;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            if (this.m_nFunctionId == -13) {
                CallChain chain = frame.m_chain;
                if (chain == null) {
                    throw new IllegalStateException();
                }
                ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, chain.getSuper(frame).getMaxVars());
                if (Call_N0.anyDeferred(ahVar)) {
                    Frame.Continuation stepNext = frameCaller -> chain.callSuperN1(frame, ahVar, -2, false);
                    return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
                }
                return chain.callSuperN1(frame, ahVar, -2, false);
            }
            if (this.m_nFunctionId <= -16) {
                MethodStructure function = this.getMethodStructure(frame);
                if (function == null) {
                    return -3;
                }
                ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, function.getMaxVars());
                if (Call_N0.anyDeferred(ahVar)) {
                    Frame.Continuation stepNext = frameCaller -> frame.call1(function, null, ahVar, -2);
                    return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
                }
                if (function.isNative()) {
                    return this.getNativeTemplate(frame, function).invokeNativeN(frame, function, null, ahVar, -2);
                }
                return frame.call1(function, null, ahVar, -2);
            }
            ObjectHandle hFunction = frame.getArgument(this.m_nFunctionId);
            return Call_N0.isDeferred(hFunction) ? hFunction.proceed(frame, frameCaller -> this.complete(frameCaller, (xRTFunction.FunctionHandle)frameCaller.popStack())) : this.complete(frame, (xRTFunction.FunctionHandle)hFunction);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, xRTFunction.FunctionHandle hFunction) {
        try {
            ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, hFunction.getVarCount());
            if (Call_N0.anyDeferred(ahVar)) {
                Frame.Continuation stepNext = frameCaller -> hFunction.call1(frameCaller, null, ahVar, -2);
                return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
            }
            return hFunction.call1(frame, null, ahVar, -2);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Call_N0.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Call_N0.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildCall(bctx, code, this.m_anArgValue);
    }
}

