/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.util.Handy;

public class Call_N1
extends OpCallable {
    private int[] m_anArgValue;
    private Argument[] m_aArgValue;

    public Call_N1(Argument argFunction, Argument[] aArgValue, Argument argReturn) {
        super(argFunction);
        this.m_aArgValue = aArgValue;
        this.m_argReturn = argReturn;
    }

    public Call_N1(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anArgValue = Call_N1.readIntArray(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anArgValue = Call_N1.encodeArguments(this.m_aArgValue, registry);
            this.m_nRetValue = Call_N1.encodeArgument(this.m_argReturn, registry);
        }
        Call_N1.writeIntArray(out, this.m_anArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 25;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            if (this.m_nFunctionId == -13) {
                CallChain chain = frame.m_chain;
                if (chain == null) {
                    throw new IllegalStateException();
                }
                MethodStructure methodSuper = chain.getSuper(frame);
                this.checkReturnRegister(frame, methodSuper);
                ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, methodSuper.getMaxVars());
                if (Call_N1.anyDeferred(ahVar)) {
                    Frame.Continuation stepNext = frameCaller -> chain.callSuperN1(frame, ahVar, this.m_nRetValue, false);
                    return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
                }
                return chain.callSuperN1(frame, ahVar, this.m_nRetValue, false);
            }
            if (this.m_nFunctionId <= -16) {
                MethodStructure function = this.getMethodStructure(frame);
                if (function == null) {
                    return -3;
                }
                ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, function.getMaxVars());
                this.checkReturnRegister(frame, function);
                if (Call_N1.anyDeferred(ahVar)) {
                    Frame.Continuation stepNext = frameCaller -> frame.call1(function, null, ahVar, this.m_nRetValue);
                    return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
                }
                if (function.isNative()) {
                    return this.getNativeTemplate(frame, function).invokeNativeN(frame, function, null, ahVar, this.m_nRetValue);
                }
                return frame.call1(function, null, ahVar, this.m_nRetValue);
            }
            ObjectHandle hFunction = frame.getArgument(this.m_nFunctionId);
            return Call_N1.isDeferred(hFunction) ? hFunction.proceed(frame, frameCaller -> this.complete(frameCaller, (xRTFunction.FunctionHandle)frameCaller.popStack())) : this.complete(frame, (xRTFunction.FunctionHandle)hFunction);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, xRTFunction.FunctionHandle hFunction) {
        try {
            ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, hFunction.getVarCount());
            if (Call_N1.anyDeferred(ahVar)) {
                Frame.Continuation stepNext = frameCaller -> hFunction.call1(frameCaller, null, ahVar, this.m_nRetValue);
                return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
            }
            return hFunction.call1(frame, null, ahVar, this.m_nRetValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Call_N1.registerArguments(this.m_aArgValue, registry);
        this.m_argReturn = Call_N1.registerArgument(this.m_argReturn, registry);
    }

    @Override
    protected String getParamsString() {
        return Call_N1.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildCall(bctx, code, this.m_anArgValue);
    }
}

