/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;

public class Call_NN
extends OpCallable {
    private int[] m_anArgValue;
    private Argument[] m_aArgValue;

    public Call_NN(Argument argFunction, Argument[] aArgValue, Argument[] aArgReturn) {
        super(argFunction);
        this.m_aArgValue = aArgValue;
        this.m_aArgReturn = aArgReturn;
    }

    public Call_NN(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anArgValue = Call_NN.readIntArray(in);
        this.m_anRetValue = Call_NN.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anArgValue = Call_NN.encodeArguments(this.m_aArgValue, registry);
            this.m_anRetValue = Call_NN.encodeArguments(this.m_aArgReturn, registry);
        }
        Call_NN.writeIntArray(out, this.m_anArgValue);
        Call_NN.writeIntArray(out, this.m_anRetValue);
    }

    @Override
    public int getOpCode() {
        return 26;
    }

    @Override
    protected boolean isMultiReturn() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            if (this.m_nFunctionId == -13) {
                CallChain chain = frame.m_chain;
                if (chain == null) {
                    throw new IllegalStateException();
                }
                MethodStructure methodSuper = chain.getSuper(frame);
                this.checkReturnRegisters(frame, methodSuper);
                ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, methodSuper.getMaxVars());
                if (Call_NN.anyDeferred(ahVar)) {
                    Frame.Continuation stepNext = frameCaller -> chain.callSuperNN(frame, ahVar, this.m_anRetValue);
                    return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
                }
                return chain.callSuperNN(frame, ahVar, this.m_anRetValue);
            }
            if (this.m_nFunctionId <= -16) {
                MethodStructure function = this.getMethodStructure(frame);
                if (function == null) {
                    return -3;
                }
                ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, function.getMaxVars());
                this.checkReturnRegisters(frame, function);
                if (Call_NN.anyDeferred(ahVar)) {
                    Frame.Continuation stepNext = frameCaller -> frame.callN(function, null, ahVar, this.m_anRetValue);
                    return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
                }
                if (function.isNative()) {
                    return this.getNativeTemplate(frame, function).invokeNativeNN(frame, function, null, ahVar, this.m_anRetValue);
                }
                return frame.callN(function, null, ahVar, this.m_anRetValue);
            }
            ObjectHandle hFunction = frame.getArgument(this.m_nFunctionId);
            return Call_NN.isDeferred(hFunction) ? hFunction.proceed(frame, frameCaller -> this.complete(frameCaller, (xRTFunction.FunctionHandle)frameCaller.popStack())) : this.complete(frame, (xRTFunction.FunctionHandle)hFunction);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, xRTFunction.FunctionHandle hFunction) {
        try {
            ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, hFunction.getVarCount());
            if (Call_NN.anyDeferred(ahVar)) {
                Frame.Continuation stepNext = frameCaller -> hFunction.callN(frameCaller, null, ahVar, this.m_anRetValue);
                return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
            }
            return hFunction.callN(frame, null, ahVar, this.m_anRetValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Call_NN.registerArguments(this.m_aArgValue, registry);
        Call_NN.registerArguments(this.m_aArgReturn, registry);
    }

    @Override
    protected String getParamsString() {
        return Call_NN.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildCall(bctx, code, this.m_anArgValue);
    }
}

