/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.util.Handy;

public class Call_T0
extends OpCallable {
    private int m_nArgTupleValue;
    private Argument m_argValue;

    public Call_T0(Argument argFunction, Argument argValue) {
        super(argFunction);
        this.m_argValue = argValue;
    }

    public Call_T0(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgTupleValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgTupleValue = Call_T0.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nArgTupleValue);
    }

    @Override
    public int getOpCode() {
        return 28;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nArgTupleValue);
            if (this.m_nFunctionId == -13) {
                CallChain chain = frame.m_chain;
                if (chain == null) {
                    throw new IllegalStateException();
                }
                return Call_T0.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> chain.callSuperN1(frameCaller, ((xTuple.TupleHandle)frameCaller.popStack()).m_ahValue, -2, false)) : chain.callSuperN1(frame, ((xTuple.TupleHandle)hArg).m_ahValue, -2, false);
            }
            if (this.m_nFunctionId <= -16) {
                MethodStructure function = this.getMethodStructure(frame);
                if (function == null) {
                    return -3;
                }
                return Call_T0.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, function, (xTuple.TupleHandle)frameCaller.popStack())) : this.complete(frame, function, (xTuple.TupleHandle)hArg);
            }
            ObjectHandle hFunction = frame.getArgument(this.m_nFunctionId);
            if (Call_T0.isDeferred(hArg) || Call_T0.isDeferred(hFunction)) {
                ObjectHandle[] ahArg = new ObjectHandle[]{hArg, hFunction};
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, (xRTFunction.FunctionHandle)ahArg[1], (xTuple.TupleHandle)ahArg[0]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.complete(frame, (xRTFunction.FunctionHandle)hFunction, (xTuple.TupleHandle)hArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, MethodStructure function, xTuple.TupleHandle hArg) {
        ObjectHandle[] ahArg = hArg.m_ahValue;
        if (ahArg.length != function.getParamCount()) {
            return frame.raiseException("Invalid tuple argument");
        }
        if (function.isNative()) {
            return this.getNativeTemplate(frame, function).invokeNativeN(frame, function, null, ahArg, -2);
        }
        ObjectHandle[] ahVar = Utils.ensureSize(ahArg, function.getMaxVars());
        return frame.call1(function, null, ahVar, -2);
    }

    protected int complete(Frame frame, xRTFunction.FunctionHandle hFunction, xTuple.TupleHandle hArg) {
        ObjectHandle[] ahArg = hArg.m_ahValue;
        if (ahArg.length != hFunction.getParamCount()) {
            return frame.raiseException("Invalid tuple argument");
        }
        ObjectHandle[] ahVar = Utils.ensureSize(ahArg, hFunction.getVarCount());
        return hFunction.call1(frame, null, ahVar, -2);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Call_T0.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgTupleValue);
    }
}

