/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.StringConstant;
import org.xvm.runtime.Frame;

public class CatchStart
extends OpVar {
    private int m_nNameId;
    private StringConstant m_constName;

    public CatchStart(Register reg, StringConstant constName) {
        super(reg);
        if (!reg.getType().isA(reg.getType().getConstantPool().typeException())) {
            throw new IllegalArgumentException("catch type must be an exception type");
        }
        if (constName == null) {
            throw new IllegalArgumentException("name required");
        }
        this.m_constName = constName;
    }

    public CatchStart(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    void preWrite(Op.ConstantRegistry registry) {
        this.m_nType = CatchStart.encodeArgument(this.getRegisterType(), registry);
        if (this.m_constName != null) {
            this.m_nNameId = CatchStart.encodeArgument(this.m_constName, registry);
        }
    }

    int getTypeId() {
        return this.m_nType;
    }

    void setTypeId(int nType) {
        this.m_nType = nType;
    }

    int getNameId() {
        return this.m_nNameId;
    }

    void setNameId(int nName) {
        this.m_nNameId = nName;
    }

    @Override
    protected boolean isTypeAware() {
        return false;
    }

    @Override
    public int getOpCode() {
        return 9;
    }

    @Override
    public boolean isEnter() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        return iPC + 1;
    }

    @Override
    public void markReachable(Op[] aop) {
        super.markReachable(aop);
        this.findCorrespondingOp(aop, 10).markNecessary();
    }

    @Override
    public void simulate(Scope scope) {
        scope.enter(this);
        super.simulate(scope);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_constName = (StringConstant)CatchStart.registerArgument(this.m_constName, registry);
    }

    @Override
    public String getName(Constant[] aconst) {
        return this.getName(aconst, this.m_constName, this.m_nNameId);
    }
}

