/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public class Construct_1
extends OpCallable {
    private int m_nArgValue;
    private Argument m_argValue;

    public Construct_1(MethodConstant constMethod, Argument argValue) {
        super(constMethod);
        this.m_argValue = argValue;
    }

    public Construct_1(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgValue = Construct_1.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nArgValue);
    }

    @Override
    public int getOpCode() {
        return 53;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nArgValue);
            MethodStructure constructor = this.getConstructor(frame);
            if (constructor == null) {
                return -3;
            }
            if (constructor.isNative()) {
                return this.reportNonExtendable(frame, constructor);
            }
            ObjectHandle[] ahVar = new ObjectHandle[constructor.getMaxVars()];
            ahVar[0] = hArg;
            if (Construct_1.isDeferred(hArg)) {
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, constructor, ahVar);
                return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
            }
            return this.complete(frame, constructor, ahVar);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, MethodStructure constructor, ObjectHandle[] ahVar) {
        if (constructor.isNoOp()) {
            return -1;
        }
        ObjectHandle hStruct = frame.getThis();
        frame.chainFinalizer(Utils.makeFinalizer(frame, constructor, ahVar));
        return frame.call1(constructor, hStruct, ahVar, -2);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Construct_1.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildConstruct(bctx, code, new int[]{this.m_nArgValue});
    }
}

