/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;

public class Construct_N
extends OpCallable {
    private int[] m_anArgValue;
    private Argument[] m_aArgValue;

    public Construct_N(MethodConstant constMethod, Argument[] aArgValue) {
        super(constMethod);
        this.m_aArgValue = aArgValue;
    }

    public Construct_N(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anArgValue = Construct_N.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anArgValue = Construct_N.encodeArguments(this.m_aArgValue, registry);
        }
        Construct_N.writeIntArray(out, this.m_anArgValue);
    }

    @Override
    public int getOpCode() {
        return 54;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            MethodStructure constructor = this.getConstructor(frame);
            if (constructor == null) {
                return -3;
            }
            if (constructor.isNative()) {
                return this.reportNonExtendable(frame, constructor);
            }
            ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, constructor.getMaxVars());
            if (Construct_N.anyDeferred(ahVar)) {
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, constructor, ahVar);
                return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
            }
            return this.complete(frame, constructor, ahVar);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, MethodStructure constructor, ObjectHandle[] ahVar) {
        if (constructor.isNoOp()) {
            return -1;
        }
        ObjectHandle hStruct = frame.getThis();
        frame.chainFinalizer(Utils.makeFinalizer(frame, constructor, ahVar));
        return frame.call1(constructor, hStruct, ahVar, -2);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Construct_N.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Construct_N.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildConstruct(bctx, code, this.m_anArgValue);
    }
}

