/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.util.Handy;

public class Construct_T
extends OpCallable {
    private int m_nArgTupleValue;
    private Argument m_argValue;

    public Construct_T(MethodConstant constMethod, Argument argValue) {
        super(constMethod);
        this.m_argValue = argValue;
    }

    public Construct_T(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgTupleValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgTupleValue = Construct_T.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nArgTupleValue);
    }

    @Override
    public int getOpCode() {
        return 55;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nArgTupleValue);
            return Construct_T.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, ((xTuple.TupleHandle)frameCaller.popStack()).m_ahValue)) : this.complete(frame, ((xTuple.TupleHandle)hArg).m_ahValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle[] ahArg) {
        MethodStructure constructor = this.getConstructor(frame);
        if (constructor == null) {
            return -3;
        }
        if (constructor.isNative()) {
            return this.reportNonExtendable(frame, constructor);
        }
        if (constructor.isNoOp()) {
            return -1;
        }
        ObjectHandle hStruct = frame.getThis();
        ObjectHandle[] ahVar = Utils.ensureSize(ahArg, constructor.getMaxVars());
        frame.chainFinalizer(Utils.makeFinalizer(frame, constructor, ahVar));
        return frame.call1(constructor, hStruct, ahVar, -2);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Construct_T.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgTupleValue);
    }
}

