/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.util.Handy;

public class FBind
extends OpCallable {
    private final int[] m_anParamIx;
    private int[] m_anParamValue;
    private Argument[] m_aArgParam;

    public FBind(Argument argFunction, int[] anParamIx, Argument[] aArgValue, Argument argReturn) {
        super(argFunction);
        this.m_anParamIx = anParamIx;
        this.m_aArgParam = aArgValue;
        this.m_argReturn = argReturn;
    }

    public FBind(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        int c = Handy.readPackedInt(in);
        this.m_anParamIx = new int[c];
        this.m_anParamValue = new int[c];
        for (int i = 0; i < c; ++i) {
            this.m_anParamIx[i] = Handy.readPackedInt(in);
            this.m_anParamValue[i] = Handy.readPackedInt(in);
        }
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgParam != null) {
            this.m_anParamValue = FBind.encodeArguments(this.m_aArgParam, registry);
            this.m_nRetValue = FBind.encodeArgument(this.m_argReturn, registry);
        }
        int c = this.m_anParamIx.length;
        Handy.writePackedLong(out, c);
        for (int i = 0; i < c; ++i) {
            Handy.writePackedLong(out, this.m_anParamIx[i]);
            Handy.writePackedLong(out, this.m_anParamValue[i]);
        }
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 49;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            xRTFunction.FunctionHandle hFunction;
            int nFunctionId = this.m_nFunctionId;
            if (nFunctionId == -13) {
                CallChain chain = frame.m_chain;
                if (chain == null) {
                    throw new IllegalStateException();
                }
                int nDepth = frame.m_nChainDepth + 1;
                if (nDepth >= chain.getDepth()) {
                    return frame.raiseException("Invalid \"super\" reference");
                }
                hFunction = xRTFunction.makeHandle(frame, chain, nDepth).bindTarget(frame, frame.getThis());
            } else if (nFunctionId <= -16) {
                MethodStructure function = this.getMethodStructure(frame);
                if (function == null) {
                    return -3;
                }
                ObjectHandle hFn = xRTFunction.makeHandle(frame, function);
                if (FBind.isDeferred(hFn)) {
                    return hFn.proceed(frame, frameCaller -> this.resolveArguments(frameCaller, (xRTFunction.FunctionHandle)frameCaller.popStack()));
                }
                hFunction = (xRTFunction.FunctionHandle)hFn;
            } else {
                ObjectHandle hFn = frame.getArgument(nFunctionId);
                if (FBind.isDeferred(hFn)) {
                    return hFn.proceed(frame, frameCaller -> this.resolveArguments(frameCaller, (xRTFunction.FunctionHandle)frameCaller.popStack()));
                }
                hFunction = (xRTFunction.FunctionHandle)hFn;
            }
            return this.resolveArguments(frame, hFunction);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int resolveArguments(Frame frame, xRTFunction.FunctionHandle hFunction) {
        try {
            ObjectHandle[] ahParam = frame.getArguments(this.m_anParamValue, 0);
            if (FBind.anyDeferred(ahParam)) {
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, hFunction, ahParam);
                return new Utils.GetArguments(ahParam, stepNext).doNext(frame);
            }
            return this.complete(frame, hFunction, ahParam);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, xRTFunction.FunctionHandle hFunction, ObjectHandle[] ahParam) {
        int[] anParamIx = this.m_anParamIx;
        int c = anParamIx.length;
        for (int i = 0; i < c; ++i) {
            hFunction = hFunction.bind(frame, anParamIx[i] - i, ahParam[i]);
        }
        int nRetVal = this.m_nRetValue;
        if (frame.isNextRegister(nRetVal)) {
            frame.introduceResolvedVar(nRetVal, frame.poolContext().typeFunction());
        }
        return frame.assignValue(nRetVal, hFunction);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        FBind.registerArguments(this.m_aArgParam, registry);
    }

    @Override
    protected String getParamsString() {
        StringBuilder sb = new StringBuilder();
        int cArgNums = this.m_anParamValue == null ? 0 : this.m_anParamValue.length;
        int cArgRefs = this.m_aArgParam == null ? 0 : this.m_aArgParam.length;
        int c = this.m_anParamIx.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('[').append(this.m_anParamIx[i]).append("]=").append(Argument.toIdString(i < cArgRefs ? this.m_aArgParam[i] : null, i < cArgNums ? this.m_anParamValue[i] : 1000000000));
        }
        return sb.toString();
    }
}

