/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.OpGeneral;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.javajit.BuildContext;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;

public class GP_Add
extends OpGeneral {
    public GP_Add(Argument argTarget, Argument argValue, Argument argReturn) {
        super(argTarget, argValue, argReturn);
    }

    public GP_Add(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 147;
    }

    @Override
    protected int completeBinary(Frame frame, ObjectHandle hTarget, ObjectHandle hArg) {
        return hTarget.getOpSupport().invokeAdd(frame, hTarget, hArg, this.m_nRetValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        BuildContext.Slot slotTarget = bctx.loadArgument(code, this.m_nTarget);
        if (!slotTarget.isSingle()) {
            throw new UnsupportedOperationException("'+' operation on multi-slot");
        }
        ClassDesc cdTarget = slotTarget.cd();
        TypeConstant typeRet = slotTarget.type();
        if (cdTarget.isPrimitive()) {
            BuildContext.Slot slotArg = bctx.loadArgument(code, this.m_nArgValue);
            if (!slotArg.cd().equals(cdTarget)) {
                throw new UnsupportedOperationException("Convert " + slotArg.type().getValueString() + " to " + slotTarget.type().getValueString());
            }
            switch (cdTarget.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    code.iadd();
                    break;
                }
                case "J": {
                    code.ladd();
                    break;
                }
                case "F": {
                    code.fadd();
                    break;
                }
                case "D": {
                    code.dadd();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            MethodTypeDesc md;
            TypeInfo info = slotTarget.type().ensureTypeInfo();
            MethodInfo method = info.findOpMethod("add", "+", 1);
            Object sJitName = method.getIdentity().ensureJitMethodName(bctx.typeSystem);
            JitMethodDesc jmd = method.getJitDesc(bctx.typeSystem);
            if (jmd.isOptimized) {
                md = jmd.optimizedMD;
                sJitName = (String)sJitName + "$p";
            } else {
                md = jmd.standardMD;
            }
            bctx.loadCtx(code);
            bctx.loadArgument(code, this.m_nArgValue);
            code.invokevirtual(slotTarget.cd(), (String)sJitName, md);
        }
        bctx.storeValue(code, bctx.ensureSlot(this.m_nRetValue, typeRet));
    }
}

