/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.OpGeneral;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;

public class GP_Compl
extends OpGeneral {
    public GP_Compl(Argument argValue, Argument argResult) {
        super(argValue, argResult);
    }

    public GP_Compl(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 164;
    }

    @Override
    protected boolean isBinaryOp() {
        return false;
    }

    @Override
    protected int completeUnary(Frame frame, ObjectHandle hTarget) {
        return hTarget.getOpSupport().invokeCompl(frame, hTarget, this.m_nRetValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        BuildContext.Slot slotTarget = bctx.loadArgument(code, this.m_nTarget);
        if (!slotTarget.isSingle()) {
            throw new UnsupportedOperationException("'~' operation on multi-slot");
        }
        ClassDesc cdTarget = slotTarget.cd();
        TypeConstant typeRet = slotTarget.type();
        if (cdTarget.isPrimitive()) {
            switch (cdTarget.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    code.iconst_m1().ixor();
                    break;
                }
                case "J": {
                    code.ldc((ConstantDesc)Long.valueOf(-1L)).lxor();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            throw new UnsupportedOperationException("TODO:  ~" + slotTarget.type().getValueString());
        }
        bctx.storeValue(code, bctx.ensureSlot(this.m_nRetValue, typeRet));
    }
}

