/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.Scope;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public class GP_DivRem
extends Op {
    protected int m_nTarget;
    protected int m_nArgValue;
    protected int[] m_anRetValue;
    private Argument m_argTarget;
    private Argument m_argValue;
    private Argument[] m_aargReturn;

    public GP_DivRem(Argument argTarget, Argument argValue, Argument[] aargReturn) {
        this.m_argTarget = argTarget;
        this.m_argValue = argValue;
        this.m_aargReturn = aargReturn;
    }

    public GP_DivRem(DataInput in, Constant[] aconst) throws IOException {
        this.m_nTarget = Handy.readPackedInt(in);
        this.m_nArgValue = Handy.readPackedInt(in);
        this.m_anRetValue = GP_DivRem.readIntArray(in);
    }

    @Override
    public int getOpCode() {
        return 158;
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = GP_DivRem.encodeArgument(this.m_argTarget, registry);
            this.m_nArgValue = GP_DivRem.encodeArgument(this.m_argValue, registry);
            this.m_anRetValue = GP_DivRem.encodeArguments(this.m_aargReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nTarget);
        Handy.writePackedLong(out, this.m_nArgValue);
        GP_DivRem.writeIntArray(out, this.m_anRetValue);
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(new int[]{this.m_nTarget, this.m_nArgValue}, 2);
            if (frame.isNextRegister(this.m_anRetValue[0])) {
                frame.introduceVarCopy(this.m_anRetValue[0], this.m_nTarget);
            }
            if (frame.isNextRegister(this.m_anRetValue[1])) {
                frame.introduceVarCopy(this.m_anRetValue[1], this.m_nTarget);
            }
            if (GP_DivRem.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, ahArg[0], ahArg[1]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.complete(frame, ahArg[0], ahArg[1]);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hTarget, ObjectHandle hArg) {
        return hTarget.getOpSupport().invokeDivRem(frame, hTarget, hArg, this.m_anRetValue);
    }

    @Override
    public void resetSimulation() {
        GP_DivRem.resetRegisters(this.m_aargReturn);
    }

    @Override
    public void simulate(Scope scope) {
        GP_DivRem.checkNextRegisters(scope, this.m_aargReturn, this.m_anRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argTarget = GP_DivRem.registerArgument(this.m_argTarget, registry);
        this.m_argValue = GP_DivRem.registerArgument(this.m_argValue, registry);
        GP_DivRem.registerArguments(this.m_aargReturn, registry);
    }

    @Override
    public String toString() {
        Argument argRet0 = this.m_aargReturn == null ? null : this.m_aargReturn[0];
        Argument argRet1 = this.m_aargReturn == null ? null : this.m_aargReturn[1];
        int nRet0 = this.m_anRetValue == null ? 0 : this.m_anRetValue[0];
        int nRet1 = this.m_anRetValue == null ? 0 : this.m_anRetValue[1];
        return super.toString() + " " + Argument.toIdString(this.m_argTarget, this.m_nTarget) + ", " + Argument.toIdString(this.m_argValue, this.m_nArgValue) + ", " + Argument.toIdString(argRet0, nRet0) + ", " + Argument.toIdString(argRet1, nRet1);
    }
}

