/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.OpGeneral;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;

public class GP_Mod
extends OpGeneral {
    public GP_Mod(Argument argTarget, Argument argValue, Argument argReturn) {
        super(argTarget, argValue, argReturn);
    }

    public GP_Mod(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 151;
    }

    @Override
    protected int completeBinary(Frame frame, ObjectHandle hTarget, ObjectHandle hArg) {
        return hTarget.getOpSupport().invokeMod(frame, hTarget, hArg, this.m_nRetValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        BuildContext.Slot slotTarget = bctx.loadArgument(code, this.m_nTarget);
        BuildContext.Slot slotArg = bctx.loadArgument(code, this.m_nArgValue);
        if (!slotTarget.isSingle() || !slotArg.isSingle()) {
            throw new UnsupportedOperationException("'%' operation on multi-slot");
        }
        ClassDesc cdTarget = slotTarget.cd();
        TypeConstant typeRet = slotTarget.type();
        if (cdTarget.isPrimitive()) {
            switch (cdTarget.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    code.irem();
                    break;
                }
                case "J": {
                    code.lrem();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            throw new UnsupportedOperationException("TODO: " + slotTarget.type().getValueString() + " % " + slotArg.type().getValueString());
        }
        bctx.storeValue(code, bctx.ensureSlot(this.m_nRetValue, typeRet));
    }
}

