/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpJump;
import org.xvm.asm.Scope;
import org.xvm.runtime.Frame;

public class GuardAll
extends OpJump {
    private int m_nNextVar;
    private transient Frame.AllGuard m_guard;

    public GuardAll(Op op) {
        super(op);
    }

    public GuardAll(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 11;
    }

    @Override
    public boolean isEnter() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        int iScope = frame.enterScope(this.m_nNextVar);
        Frame.AllGuard guard = this.m_guard;
        if (guard == null) {
            this.m_guard = guard = new Frame.AllGuard(iPC, iScope, this.m_ofJmp);
        }
        frame.pushGuard(guard);
        return iPC + 1;
    }

    @Override
    public void simulate(Scope scope) {
        scope.enterGuardAll();
        scope.enter(this);
        this.m_nNextVar = scope.getCurVars();
    }

    @Override
    public boolean advances() {
        return true;
    }
}

