/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Scope;
import org.xvm.asm.op.CatchStart;
import org.xvm.runtime.Frame;
import org.xvm.util.Handy;

public class GuardStart
extends Op {
    private int[] m_anTypeId;
    private int[] m_anNameId;
    private int[] m_aofCatch;
    private CatchStart[] m_aOpCatch;
    private int m_nNextVar;
    private transient Frame.MultiGuard m_guard;

    public GuardStart(CatchStart[] aOpCatch) {
        this.m_aOpCatch = aOpCatch;
    }

    public GuardStart(DataInput in, Constant[] aconst) throws IOException {
        int c = Handy.readPackedInt(in);
        this.m_anTypeId = new int[c];
        this.m_anNameId = new int[c];
        this.m_aofCatch = new int[c];
        for (int i = 0; i < c; ++i) {
            this.m_anTypeId[i] = Handy.readPackedInt(in);
            this.m_anNameId[i] = Handy.readPackedInt(in);
            this.m_aofCatch[i] = Handy.readPackedInt(in);
        }
    }

    @Override
    public void resolveCode(MethodStructure.Code code, Constant[] aconst) {
        super.resolveCode(code, aconst);
        int ofThis = this.getAddress();
        int c = this.m_aofCatch.length;
        this.m_aOpCatch = new CatchStart[c];
        for (int i = 0; i < c; ++i) {
            CatchStart op = (CatchStart)code.get(ofThis + this.m_aofCatch[i]);
            op.setNameId(this.m_anNameId[i]);
            op.setTypeId(this.m_anTypeId[i]);
            this.m_aOpCatch[i] = op;
        }
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aOpCatch != null) {
            int cCatch = this.m_aOpCatch.length;
            int[] anTypeId = new int[cCatch];
            int[] anNameId = new int[cCatch];
            for (int i = 0; i < cCatch; ++i) {
                CatchStart op = this.m_aOpCatch[i];
                op.preWrite(registry);
                anTypeId[i] = op.getTypeId();
                anNameId[i] = op.getNameId();
            }
            this.m_anTypeId = anTypeId;
            this.m_anNameId = anNameId;
        }
        int c = this.m_anTypeId.length;
        Handy.writePackedLong(out, c);
        for (int i = 0; i < c; ++i) {
            Handy.writePackedLong(out, this.m_anTypeId[i]);
            Handy.writePackedLong(out, this.m_anNameId[i]);
            Handy.writePackedLong(out, this.m_aofCatch[i]);
        }
    }

    @Override
    public void resolveAddresses(Op[] aop) {
        if (this.m_aOpCatch == null) {
            int ofThis = this.getAddress();
            int c = this.m_aofCatch.length;
            this.m_aOpCatch = new CatchStart[c];
            for (int i = 0; i < c; ++i) {
                int ofOp;
                this.m_aofCatch[i] = ofOp = this.adjustRelativeAddress(aop, this.m_aofCatch[i]);
                this.m_aOpCatch[i] = (CatchStart)aop[ofThis + ofOp];
            }
        } else {
            int c = this.m_aOpCatch.length;
            this.m_aofCatch = new int[c];
            for (int i = 0; i < c; ++i) {
                this.m_aofCatch[i] = this.calcRelativeAddress(this.m_aOpCatch[i]);
            }
        }
    }

    @Override
    public int getOpCode() {
        return 7;
    }

    @Override
    public boolean isEnter() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        int iScope = frame.enterScope(this.m_nNextVar);
        Frame.MultiGuard guard = this.m_guard;
        if (guard == null) {
            this.m_guard = guard = new Frame.MultiGuard(iPC, iScope, this.m_anTypeId, this.m_anNameId, this.m_aofCatch);
        }
        frame.pushGuard(guard);
        return iPC + 1;
    }

    @Override
    public void markReachable(Op[] aop) {
        super.markReachable(aop);
        this.findCorrespondingOp(aop, 8).markNecessary();
    }

    @Override
    public void simulate(Scope scope) {
        scope.enterGuard();
        scope.enter(this);
        this.m_nNextVar = scope.getCurVars();
    }

    @Override
    public boolean branches(Op[] aop, List<Integer> list) {
        this.resolveAddresses(aop);
        for (int i : this.m_aofCatch) {
            list.add(i);
        }
        return true;
    }
}

