/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.OpIndexInPlace;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.IndexSupport;

public class IIP_Add
extends OpIndexInPlace {
    public IIP_Add(Argument argTarget, Argument argIndex, Argument argValue) {
        super(argTarget, argIndex, argValue);
    }

    public IIP_Add(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 213;
    }

    @Override
    protected int complete(Frame frame, ObjectHandle hTarget, ObjectHandle.JavaLong hIndex, ObjectHandle hValue) {
        ObjectHandle hCurrent;
        IndexSupport template = (IndexSupport)((Object)hTarget.getOpSupport());
        long lIndex = hIndex.getValue();
        switch (template.extractArrayValue(frame, hTarget, lIndex, -1)) {
            case -1: {
                hCurrent = frame.popStack();
                break;
            }
            case -3: {
                return -3;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (hCurrent.getOpSupport().invokeAdd(frame, hCurrent, hValue, -1)) {
            case -1: {
                return template.assignArrayValue(frame, hTarget, lIndex, frame.popStack());
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> template.assignArrayValue(frameCaller, hTarget, lIndex, frameCaller.popStack()));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }
}

