/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.OpInPlace;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.reflect.xRef;

public class IP_PostInc
extends OpInPlace {
    public IP_PostInc(int nTarget, int nRet) {
        super((Argument)null, null);
        this.m_nTarget = nTarget;
        this.m_nRetValue = nRet;
    }

    public IP_PostInc(Argument argTarget, Argument argReturn) {
        super(argTarget, argReturn);
    }

    public IP_PostInc(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 173;
    }

    @Override
    protected int completeWithRegister(Frame frame, ObjectHandle hTarget) {
        switch (hTarget.getOpSupport().invokeNext(frame, hTarget, this.m_nTarget)) {
            case -1: {
                return frame.assignValue(this.m_nRetValue, hTarget);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(this.m_nRetValue, hTarget));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected int completeWithVar(Frame frame, xRef.RefHandle hTarget) {
        return hTarget.getVarSupport().invokeVarPostInc(frame, hTarget, this.m_nRetValue);
    }

    @Override
    protected int completeWithProperty(Frame frame, PropertyConstant idProp) {
        ObjectHandle hTarget = frame.getThis();
        return hTarget.getTemplate().invokePostInc(frame, hTarget, idProp, this.m_nRetValue);
    }
}

