/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.OpIndex;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.IndexSupport;

public class I_Get
extends OpIndex {
    public I_Get(Argument argTarget, Argument argIndex, Argument argReturn) {
        super(argTarget, argIndex, argReturn);
    }

    public I_Get(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 205;
    }

    @Override
    protected int complete(Frame frame, ObjectHandle hTarget, ObjectHandle hIndex) {
        ClassTemplate template = hTarget.getTemplate();
        if (template instanceof IndexSupport) {
            long lIndex = ((ObjectHandle.JavaLong)hIndex).getValue();
            if (frame.isNextRegister(this.m_nRetValue)) {
                frame.introduceElementVar(this.m_nTarget, (int)lIndex);
            }
            return ((IndexSupport)((Object)template)).extractArrayValue(frame, hTarget, lIndex, this.m_nRetValue);
        }
        CallChain chain = this.getOpChain(frame, hTarget.getType());
        if (chain == null) {
            chain = template.findOpChain(hTarget, "getElement", "[]", hIndex);
            if (chain == null) {
                return frame.raiseException("Invalid op: \"[]\"");
            }
            this.saveOpChain(frame, hTarget.getType(), chain);
        }
        MethodStructure method = chain.getTop();
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nTarget, method.getReturnTypes()[0]);
        }
        return chain.invoke(frame, hTarget, hIndex, this.m_nRetValue);
    }
}

