/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpIndex;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.IndexSupport;
import org.xvm.util.Handy;

public class I_Set
extends OpIndex {
    protected int m_nValue;
    private Argument m_argValue;

    public I_Set(Argument argTarget, Argument argIndex, Argument argValue) {
        super(argTarget, argIndex);
        this.m_argValue = argValue;
    }

    public I_Set(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nValue = I_Set.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nValue);
    }

    @Override
    public int getOpCode() {
        return 206;
    }

    @Override
    protected boolean isAssignOp() {
        return false;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(new int[]{this.m_nTarget, this.m_nIndex, this.m_nValue}, 3);
            if (I_Set.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, ahArg[0], ahArg[1], ahArg[2]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.complete(frame, ahArg[0], ahArg[1], ahArg[2]);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hTarget, ObjectHandle hIndex, ObjectHandle hValue) {
        ClassTemplate template = hTarget.getTemplate();
        if (template instanceof IndexSupport) {
            return ((IndexSupport)((Object)template)).assignArrayValue(frame, hTarget, ((ObjectHandle.JavaLong)hIndex).getValue(), hValue);
        }
        CallChain chain = this.getOpChain(frame, hTarget.getType());
        if (chain == null) {
            chain = template.findOpChain(hTarget, "[]=", new ObjectHandle[]{hIndex, hValue});
            if (chain == null) {
                return frame.raiseException("Invalid op: \"[]=\"");
            }
            this.saveOpChain(frame, hTarget.getType(), chain);
        }
        ObjectHandle[] ahVar = new ObjectHandle[Math.max(chain.getMaxVars(), 2)];
        ahVar[0] = hIndex;
        ahVar[1] = hValue;
        return chain.invoke(frame, hTarget, ahVar, -2);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = I_Set.registerArgument(this.m_argValue, registry);
    }
}

