/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpInvocable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public class Invoke_0T
extends OpInvocable {
    public Invoke_0T(Argument argTarget, MethodConstant constMethod, Argument argReturn) {
        super(argTarget, constMethod);
        this.m_argReturn = argReturn;
    }

    public Invoke_0T(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argReturn != null) {
            this.m_nRetValue = Invoke_0T.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 35;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            return Invoke_0T.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.complete(frameCaller, frameCaller.popStack())) : this.complete(frame, hTarget);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hTarget) {
        this.checkReturnTupleRegister(frame, hTarget);
        return this.getCallChain(frame, hTarget).invokeT(frame, hTarget, Utils.OBJECTS_NONE, this.m_nRetValue);
    }
}

