/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpInvocable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class Invoke_11
extends OpInvocable {
    private int m_nArgValue;
    private Argument m_argValue;

    public Invoke_11(Argument argTarget, MethodConstant constMethod, Argument argValue, Argument argReturn) {
        super(argTarget, constMethod);
        this.m_argValue = argValue;
        this.m_argReturn = argReturn;
    }

    public Invoke_11(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgValue = Invoke_11.encodeArgument(this.m_argValue, registry);
            this.m_nRetValue = Invoke_11.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 37;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            ObjectHandle hArg = frame.getArgument(this.m_nArgValue);
            return Invoke_11.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.resolveArg(frameCaller, frameCaller.popStack(), hArg)) : this.resolveArg(frame, hTarget, hArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int resolveArg(Frame frame, ObjectHandle hTarget, ObjectHandle hArg) {
        return Invoke_11.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, hTarget, frameCaller.popStack())) : this.complete(frame, hTarget, hArg);
    }

    protected int complete(Frame frame, ObjectHandle hTarget, ObjectHandle hArg) {
        this.checkReturnRegister(frame, hTarget);
        return this.getCallChain(frame, hTarget).invoke(frame, hTarget, hArg, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Invoke_11.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildInvoke(bctx, code, new int[]{this.m_nArgValue});
    }
}

