/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpInvocable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class Invoke_1N
extends OpInvocable {
    private int m_nArgValue;
    private Argument m_argValue;

    public Invoke_1N(int nTarget, int nMethodId, int nArg, int[] anRet) {
        super((Argument)null, null);
        this.m_nTarget = nTarget;
        this.m_nMethodId = nMethodId;
        this.m_nArgValue = nArg;
        this.m_anRetValue = anRet;
    }

    public Invoke_1N(Argument argTarget, MethodConstant constMethod, Argument argValue, Argument[] aArgReturn) {
        super(argTarget, constMethod);
        this.m_argValue = argValue;
        this.m_aArgReturn = aArgReturn;
    }

    public Invoke_1N(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgValue = Handy.readPackedInt(in);
        this.m_anRetValue = Invoke_1N.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgValue = Invoke_1N.encodeArgument(this.m_argValue, registry);
            this.m_anRetValue = Invoke_1N.encodeArguments(this.m_aArgReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nArgValue);
        Invoke_1N.writeIntArray(out, this.m_anRetValue);
    }

    @Override
    public int getOpCode() {
        return 38;
    }

    @Override
    protected boolean isMultiReturn() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            ObjectHandle hArg = frame.getArgument(this.m_nArgValue);
            return Invoke_1N.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.resolveArg(frameCaller, frameCaller.popStack(), hArg)) : this.resolveArg(frame, hTarget, hArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int resolveArg(Frame frame, ObjectHandle hTarget, ObjectHandle hArg) {
        return Invoke_1N.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, hTarget, frameCaller.popStack())) : this.complete(frame, hTarget, hArg);
    }

    protected int complete(Frame frame, ObjectHandle hTarget, ObjectHandle hArg) {
        this.checkReturnRegisters(frame, hTarget);
        return this.getCallChain(frame, hTarget).invoke(frame, hTarget, hArg, this.m_anRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Invoke_1N.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildInvoke(bctx, code, new int[]{this.m_nArgValue});
    }
}

