/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpInvocable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;

public class Invoke_N0
extends OpInvocable {
    private int[] m_anArgValue;
    private Argument[] m_aArgValue;

    public Invoke_N0(Argument argTarget, MethodConstant constMethod, Argument[] aArgValue) {
        super(argTarget, constMethod);
        this.m_aArgValue = aArgValue;
    }

    public Invoke_N0(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anArgValue = Invoke_N0.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anArgValue = Invoke_N0.encodeArguments(this.m_aArgValue, registry);
        }
        Invoke_N0.writeIntArray(out, this.m_anArgValue);
    }

    @Override
    public int getOpCode() {
        return 40;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            return Invoke_N0.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.resolveArgs(frameCaller, frameCaller.popStack())) : this.resolveArgs(frame, hTarget);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int resolveArgs(Frame frame, ObjectHandle hTarget) {
        CallChain chain = this.getCallChain(frame, hTarget);
        try {
            ObjectHandle[] ahArg = frame.getArguments(this.m_anArgValue, chain.getMaxVars());
            if (Invoke_N0.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> chain.invoke(frameCaller, hTarget, ahArg, -2);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return chain.invoke(frame, hTarget, ahArg, -2);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Invoke_N0.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Invoke_N0.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildInvoke(bctx, code, this.m_anArgValue);
    }
}

