/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpInvocable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public class Invoke_N1
extends OpInvocable {
    private int[] m_anArgValue;
    private Argument[] m_aArgValue;

    public Invoke_N1(Argument argTarget, MethodConstant constMethod, Argument[] aArgValue, Argument argReturn) {
        super(argTarget, constMethod);
        this.m_aArgValue = aArgValue;
        this.m_argReturn = argReturn;
    }

    public Invoke_N1(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anArgValue = Invoke_N1.readIntArray(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anArgValue = Invoke_N1.encodeArguments(this.m_aArgValue, registry);
            this.m_nRetValue = Invoke_N1.encodeArgument(this.m_argReturn, registry);
        }
        Invoke_N1.writeIntArray(out, this.m_anArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 41;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            return Invoke_N1.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.resolveArgs(frameCaller, frameCaller.popStack())) : this.resolveArgs(frame, hTarget);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int resolveArgs(Frame frame, ObjectHandle hTarget) {
        this.checkReturnRegister(frame, hTarget);
        CallChain chain = this.getCallChain(frame, hTarget);
        try {
            ObjectHandle[] ahArg = frame.getArguments(this.m_anArgValue, chain.getMaxVars());
            if (Invoke_N1.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> chain.invoke(frameCaller, hTarget, ahArg, this.m_nRetValue);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return chain.invoke(frame, hTarget, ahArg, this.m_nRetValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Invoke_N1.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Invoke_N1.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildInvoke(bctx, code, this.m_anArgValue);
    }
}

