/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpInvocable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public class Invoke_NN
extends OpInvocable {
    private int[] m_anArgValue;
    private Argument[] m_aArgValue;

    public Invoke_NN(Argument argTarget, MethodConstant constMethod, Argument[] aArgValue, Argument[] aArgReturn) {
        super(argTarget, constMethod);
        Handy.checkElementsNonNull(aArgValue);
        Handy.checkElementsNonNull(aArgReturn);
        this.m_aArgValue = aArgValue;
        this.m_aArgReturn = aArgReturn;
    }

    public Invoke_NN(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anArgValue = Invoke_NN.readIntArray(in);
        this.m_anRetValue = Invoke_NN.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anArgValue = Invoke_NN.encodeArguments(this.m_aArgValue, registry);
            this.m_anRetValue = Invoke_NN.encodeArguments(this.m_aArgReturn, registry);
        }
        Invoke_NN.writeIntArray(out, this.m_anArgValue);
        Invoke_NN.writeIntArray(out, this.m_anRetValue);
    }

    @Override
    public int getOpCode() {
        return 42;
    }

    @Override
    protected boolean isMultiReturn() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            return Invoke_NN.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.resolveArgs(frameCaller, frameCaller.popStack())) : this.resolveArgs(frame, hTarget);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int resolveArgs(Frame frame, ObjectHandle hTarget) {
        this.checkReturnRegisters(frame, hTarget);
        CallChain chain = this.getCallChain(frame, hTarget);
        try {
            ObjectHandle[] ahArg = frame.getArguments(this.m_anArgValue, chain.getMaxVars());
            if (Invoke_NN.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> chain.invoke(frameCaller, hTarget, ahArg, this.m_anRetValue);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return chain.invoke(frame, hTarget, ahArg, this.m_anRetValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Invoke_NN.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Invoke_NN.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildInvoke(bctx, code, this.m_anArgValue);
    }
}

