/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpInvocable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.util.Handy;

public class Invoke_T1
extends OpInvocable {
    private int m_nArgTupleValue;
    private Argument m_argValue;

    public Invoke_T1(Argument argTarget, MethodConstant constMethod, Argument argValue, Argument argReturn) {
        super(argTarget, constMethod);
        this.m_argValue = argValue;
        this.m_argReturn = argReturn;
    }

    public Invoke_T1(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgTupleValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgTupleValue = Invoke_T1.encodeArgument(this.m_argValue, registry);
            this.m_nRetValue = Invoke_T1.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nArgTupleValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 45;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            ObjectHandle hArg = frame.getArgument(this.m_nArgTupleValue);
            return Invoke_T1.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.resolveTuple(frameCaller, frameCaller.popStack(), hArg)) : this.resolveTuple(frame, hTarget, hArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int resolveTuple(Frame frame, ObjectHandle hTarget, ObjectHandle hArg) {
        return Invoke_T1.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, hTarget, ((xTuple.TupleHandle)frameCaller.popStack()).m_ahValue)) : this.complete(frame, hTarget, ((xTuple.TupleHandle)hArg).m_ahValue);
    }

    protected int complete(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg) {
        this.checkReturnRegister(frame, hTarget);
        return this.getCallChain(frame, hTarget).invoke(frame, hTarget, ahArg, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Invoke_T1.registerArgument(this.m_argValue, registry);
    }
}

