/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpInvocable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.util.Handy;

public class Invoke_TN
extends OpInvocable {
    private int m_nArgTupleValue;
    private Argument m_argValue;

    public Invoke_TN(Argument argTarget, MethodConstant constMethod, Argument argValue, Argument[] aArgReturn) {
        super(argTarget, constMethod);
        this.m_argValue = argValue;
        this.m_aArgReturn = aArgReturn;
    }

    public Invoke_TN(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgTupleValue = Handy.readPackedInt(in);
        this.m_anRetValue = Invoke_TN.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgTupleValue = Invoke_TN.encodeArgument(this.m_argValue, registry);
            this.m_anRetValue = Invoke_TN.encodeArguments(this.m_aArgReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nArgTupleValue);
        Invoke_TN.writeIntArray(out, this.m_anRetValue);
    }

    @Override
    public int getOpCode() {
        return 46;
    }

    @Override
    protected boolean isMultiReturn() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            ObjectHandle hArg = frame.getArgument(this.m_nArgTupleValue);
            return Invoke_TN.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.resolveTuple(frameCaller, frameCaller.popStack(), hArg)) : this.resolveTuple(frame, hTarget, hArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int resolveTuple(Frame frame, ObjectHandle hTarget, ObjectHandle hArg) {
        return Invoke_TN.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, hTarget, ((xTuple.TupleHandle)frameCaller.popStack()).m_ahValue)) : this.complete(frame, hTarget, ((xTuple.TupleHandle)hArg).m_ahValue);
    }

    protected int complete(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg) {
        this.checkReturnRegisters(frame, hTarget);
        return this.getCallChain(frame, hTarget).invoke(frame, hTarget, ahArg, this.m_anRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Invoke_TN.registerArgument(this.m_argValue, registry);
    }
}

