/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpJump;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;

public class Jump
extends OpJump {
    protected transient boolean m_fCallFinally;
    protected transient int m_ixAllGuard;
    protected transient int m_ixBaseGuard;
    protected transient int m_nJumpToScope;
    protected transient int m_cPopGuards;

    public Jump(Op op) {
        super(op);
    }

    public Jump(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 121;
    }

    @Override
    public int process(Frame frame, int iPC) {
        if (this.m_fCallFinally) {
            return frame.processAllGuard(new JumpAction(iPC + this.m_ofJmp, this.m_nJumpToScope, this.m_ixAllGuard, this.m_ixBaseGuard));
        }
        int cPop = this.m_cPopGuards;
        while (cPop-- > 0) {
            frame.popGuard();
        }
        return Jump.jump(frame, iPC + this.m_ofJmp, this.m_cExits);
    }

    @Override
    public void resolveAddresses(Op[] aop) {
        super.resolveAddresses(aop);
        Op opJumpTo = aop[this.getAddress() + this.m_ofJmp];
        int nAllDepthThis = this.getGuardAllDepth();
        int nAllDepthJump = opJumpTo.getGuardAllDepth();
        assert (nAllDepthJump <= nAllDepthThis);
        if (nAllDepthJump < nAllDepthThis) {
            Op opFinally = this.findFirstUnmatchedOp(aop, 11, 12);
            assert (opFinally.getGuardAllDepth() == nAllDepthThis);
            this.m_ixAllGuard = opFinally.getGuardDepth() + nAllDepthThis - 1;
            this.m_ixBaseGuard = nAllDepthJump - 1;
            this.m_nJumpToScope = opJumpTo.getDepth() - 1;
            this.m_fCallFinally = true;
        }
        int cPopGuards = this.getGuardDepth() - opJumpTo.getGuardDepth();
        assert (cPopGuards >= 0);
        this.m_cPopGuards = cPopGuards;
    }

    @Override
    public boolean checkRedundant(Op[] aop) {
        if (this.m_ofJmp == 1) {
            this.markRedundant();
            return true;
        }
        return false;
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        code.goto_(bctx.ensureLabel(code, this.getAddress() + this.m_ofJmp));
    }

    protected static class JumpAction
    extends Frame.DeferredGuardAction {
        private final int m_iPC;
        private final int m_nJumpScope;

        public JumpAction(int iPC, int nJumpScope, int ixAllGuard, int ixBaseGuard) {
            super(ixAllGuard, ixBaseGuard);
            this.m_iPC = iPC;
            this.m_nJumpScope = nJumpScope;
        }

        @Override
        public int complete(Frame frame) {
            while (frame.m_iScope > this.m_nJumpScope) {
                frame.exitScope();
            }
            return this.m_iPC;
        }
    }
}

