/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpJump;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class JumpInt
extends Op {
    protected int m_nArg;
    protected int[] m_aofCase;
    protected int m_ofDefault;
    private Argument m_argVal;
    private Op[] m_aOpCase;
    private Op m_opDefault;
    private transient int[] m_acExits;
    private transient int m_cDefaultExits;

    public JumpInt(Argument arg, Op[] aOpCase, Op opDefault) {
        assert (aOpCase != null);
        this.m_argVal = arg;
        this.m_aOpCase = aOpCase;
        this.m_opDefault = opDefault;
    }

    public JumpInt(DataInput in, Constant[] aconst) throws IOException {
        this.m_nArg = Handy.readPackedInt(in);
        this.m_aofCase = JumpInt.readIntArray(in);
        this.m_ofDefault = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argVal != null) {
            this.m_nArg = JumpInt.encodeArgument(this.m_argVal, registry);
        }
        Handy.writePackedLong(out, this.m_nArg);
        JumpInt.writeIntArray(out, this.m_aofCase);
        Handy.writePackedLong(out, this.m_ofDefault);
    }

    @Override
    public int getOpCode() {
        return 140;
    }

    @Override
    public void resolveAddresses(Op[] aop) {
        int i;
        int cCases;
        if (this.m_aOpCase == null) {
            int ofOp;
            int ofThis = this.getAddress();
            cCases = this.m_aofCase.length;
            this.m_aOpCase = new Op[cCases];
            for (int i2 = 0; i2 < cCases; ++i2) {
                int ofOp2;
                this.m_aofCase[i2] = ofOp2 = this.adjustRelativeAddress(aop, this.m_aofCase[i2]);
                this.m_aOpCase[i2] = aop[ofThis + ofOp2];
            }
            this.m_ofDefault = ofOp = this.adjustRelativeAddress(aop, this.m_ofDefault);
            this.m_opDefault = aop[ofThis + ofOp];
        } else {
            cCases = this.m_aOpCase.length;
            this.m_aofCase = new int[cCases];
            for (i = 0; i < cCases; ++i) {
                this.m_aofCase[i] = this.calcRelativeAddress(this.m_aOpCase[i]);
            }
            this.m_ofDefault = this.calcRelativeAddress(this.m_opDefault);
        }
        this.m_acExits = new int[cCases];
        for (i = 0; i < cCases; ++i) {
            this.m_acExits[i] = this.calcExits(this.m_aOpCase[i]);
        }
        this.m_cDefaultExits = this.calcExits(this.m_opDefault);
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hValue = frame.getArgument(this.m_nArg);
            return JumpInt.isDeferred(hValue) ? hValue.proceed(frame, frameCaller -> this.complete(frameCaller, iPC, frameCaller.popStack())) : this.complete(frame, iPC, hValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, int iPC, ObjectHandle hValue) {
        int nCase = (int)((ObjectHandle.JavaLong)hValue).getValue();
        return nCase >= 0 && nCase < this.m_aofCase.length ? JumpInt.jump(frame, iPC + this.m_aofCase[nCase], this.m_acExits[nCase]) : JumpInt.jump(frame, iPC + this.m_ofDefault, this.m_cDefaultExits);
    }

    @Override
    public void markReachable(Op[] aop) {
        super.markReachable(aop);
        Op[] aOpCase = this.m_aOpCase;
        int[] aofCase = this.m_aofCase;
        int c = aofCase.length;
        for (int i = 0; i < c; ++i) {
            aOpCase[i] = this.findDestinationOp(aop, aofCase[i]);
            aofCase[i] = this.calcRelativeAddress(aOpCase[i]);
        }
        this.m_opDefault = this.findDestinationOp(aop, this.m_ofDefault);
        this.m_ofDefault = this.calcRelativeAddress(this.m_opDefault);
    }

    @Override
    public boolean branches(Op[] aop, List<Integer> list) {
        this.resolveAddresses(aop);
        for (int i : this.m_aofCase) {
            list.add(i);
        }
        list.add(this.m_ofDefault);
        return true;
    }

    @Override
    public boolean advances() {
        return false;
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argVal = JumpInt.registerArgument(this.m_argVal, registry);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int cOps = this.m_aOpCase == null ? 0 : this.m_aOpCase.length;
        int cOffsets = this.m_aofCase == null ? 0 : this.m_aofCase.length;
        int cLabels = Math.max(cOps, cOffsets);
        sb.append(super.toString()).append(' ').append(Argument.toIdString(this.m_argVal, this.m_nArg)).append(", ").append(cLabels).append(":[");
        for (int i = 0; i < cLabels; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Op op = i < cOps ? this.m_aOpCase[i] : null;
            int of = i < cOffsets ? this.m_aofCase[i] : 0;
            sb.append(OpJump.getLabelDesc(op, of));
        }
        sb.append("], ").append(OpJump.getLabelDesc(this.m_opDefault, this.m_ofDefault));
        return sb.toString();
    }
}

